package org.fda.main;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.fda.alignment.AlignmentFilterQ;
import org.fda.alignmentparser.paf.PafReaderRunnable;
import org.fda.data.Enums;
import org.fda.data.ReferenceSet;import org.fda.data.Utilities;
import org.fda.regression.RegressionModel;
;

/**
 *
 * @author Gokhan.Yavas
 */
public class TryFilter {
    public static void main(String[] args){
        ReferenceSet refset=null;
        ObjectInputStream ois=null;
        try{
            ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream("references.bin")));
            refset=(ReferenceSet)ois.readObject();
        }
        catch(ClassNotFoundException e){e.printStackTrace();}
        catch (IOException ex) {

            if(!(ex instanceof EOFException))
                ex.printStackTrace();
        }            
        finally {
            try {
                ois.close();
            } catch (IOException ex) {
                    ex.printStackTrace();                    
            }
        }
        
        BlockingQueue filesListQueue = new ArrayBlockingQueue(10);
        List<File> z = new ArrayList();
//        z.add(new File("f6.delta"));
//        z.add(new File("f12.delta"));
        z.add(new File("deneme.paf"));
        filesListQueue.add(z);
        try(ObjectInputStream instream = new ObjectInputStream(new BufferedInputStream(new FileInputStream("model.bin")));){
            Utilities.regm = (RegressionModel)instream.readObject();
        }
        catch(ClassNotFoundException e){e.printStackTrace();}
        catch (IOException ex) {
            if(!(ex instanceof EOFException))
                ex.printStackTrace();
        }                                        
        
        
        BlockingQueue alignmentSetQueue = new ArrayBlockingQueue(10);
        BlockingQueue filteredQueue = new ArrayBlockingQueue(10);
        
        Thread pafreader = new Thread(new PafReaderRunnable(filesListQueue, alignmentSetQueue, refset ,1, new File("CONT")));
        pafreader.start();
        Thread filter = new Thread(new AlignmentFilterQ(alignmentSetQueue, 1, filteredQueue));                    
        filter.start();                
        System.out.println("D");
        
    }
}
