package org.fda.inputdataparser;

import java.io.File;
import java.util.regex.Matcher;


/**
 *
 * @author Gokhan.Yavas
 */
public class FastqReader extends Reader{
    @Override
    public ReadRecord readNextRecord(){
        String line;
        String header=null;
        ReadRecord dr=null;
        String read, qStr;
        read=qStr=null;        
        int gc_count=0;
        
        Matcher matcher;        
        int i=0; int rem=0;
        try{
            while((line = br.readLine())!=null){
                line = line.trim();
                rem = i%4;
                switch(rem){
                    case 0:
                        header=line;
                        break;
                    case 1:
                        read=line;
                        matcher = gc_pattern.matcher(read);
                        while(matcher.find())
                            gc_count++;                        
                        break;
                    case 2:
                        // Do nothing;
                        break;
                    case 3:
                        qStr=line;
                        break;                               
                }
                i++;
                if(i==4)
                    break;
            }
            if(line!=null){
                dr = new FastqRecord(header, read, qStr, gc_count);
                readrecordnumber++;            
            }
        }
        catch(Exception e){e.printStackTrace();}
        return dr;
    }
    public static void main(String[] args){
        File f = new File("2A1_CGATGT_L001_R2_002.fastq");
        Reader r = new FastqReader();
        ReadRecord fr ;
        try{
            r.openFile(f);
            while((fr=r.readNextRecord())!=null){
                //System.out.println(fr.header);
                //System.out.println(fr.formatRead(-1));
            }
            r.closeReader();
        }
        catch(Exception e){}
    }
}
