
package org.fda.inputdataparser;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import org.fda.data.Utilities;
import java.io.Serializable;
/**
 *
 * @author Gokhan.Yavas
 */
public class FastaWriter implements Serializable{
    private transient BufferedWriter bw;   
    private File fastafile;
    private long readrecordnumber = 0;
    private long size=0;
    private static final long serialVersionUID = 10211435718127689L;
    public long getReadRecordNumber(){
        return readrecordnumber;
    }

    public long getSize(){
        return size;
    }
    public FastaWriter(File f){
        this.fastafile = f;
        try{
            bw = new BufferedWriter(new FileWriter(fastafile));
        }
        catch(Exception exp){exp.printStackTrace();}
    }
    public FastaWriter(String fname){
        this.fastafile = new File(fname);
        try{
            bw = new BufferedWriter(new FileWriter(fastafile));
        }
        catch(Exception exp){exp.printStackTrace();}
        
    }
    public FastaWriter(File f, boolean append){
        this.fastafile = f;
        try{
            bw = new BufferedWriter(new FileWriter(fastafile, append));
        }
        catch(Exception exp){exp.printStackTrace();}
    }
    public FastaWriter(String fname, boolean append){
        this.fastafile = new File(fname);
        try{
            bw = new BufferedWriter(new FileWriter(fastafile, append));
        }
        catch(Exception exp){exp.printStackTrace();}
        
    }
    
    public File getFile(){
        return fastafile;
    }
    public void closeWriter(){
        try{
            bw.close();
        }
        catch(Exception e){e.printStackTrace();}
    }
    public void write(ReadRecord r){
        try{
            String wholeread = ((FastaRecord)r).formatRead(50);
            if(!wholeread.startsWith(">"))
                wholeread = ">"+wholeread;
            bw.append(wholeread+Utilities.ls);
            size += r.getReadRecordLength();
        }
        catch(Exception e){e.printStackTrace();}
    }
//    public boolean writeData(ReadRecord r){
//        try{
//            String wholeread;
//            if(r instanceof FastaRecord)
//                wholeread = r.toString();
//            else
//                wholeread = ((FastqRecord)r).getInFasta();
//             
//            if(!wholeread.startsWith(">"))
//                wholeread = ">"+wholeread;
//            if(size+r.getReadRecordLength() > Utilities.maxQueryFileSize)
//                return false;            
//            bw.append(wholeread+Utilities.ls);
//            size += r.getReadRecordLength();
//        }
//        catch(Exception e){e.printStackTrace();}
//        return true;
//    }
    
    
}
