package org.fda.inputdataparser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

/**
 *
 * @author Gokhan.Yavas
 */
public class ChromosomePicker {
    private final File in, out;
    private final Set<String> amap = new HashSet();
    public ChromosomePicker(File in, File out, File chrfile){
        this.in=in;
        this.out=out;       
        try(BufferedReader br = new BufferedReader(new FileReader(chrfile))){
            String line;
            while((line=br.readLine())!=null){
                line = line.trim();
                if(line.isEmpty())
                    continue;
                
                amap.add(line);
            }
        }
        catch(IOException ex){
            ex.printStackTrace();
        }
    }
    public void pickChrs(){
        try {
            FastaReader fr = new FastaReader();
            fr.openFile(in);
            FastaWriter frw = new FastaWriter(out);
            ReadRecord f_rec;
            while((f_rec=fr.readNextRecord())!=null){
                if(amap.contains(f_rec.getName()))
                    frw.write(f_rec);                
            }
            fr.closeReader();
            frw.closeWriter();            
        } catch (IOException ex) {
            ex.printStackTrace();
        }
    }
    
}
