package org.fda.graphdrawing.data;

import java.text.NumberFormat;
import org.fda.data.Utilities;
import org.jfree.data.statistics.HistogramDataset;

/**
 *
 * @author Gokhan.Yavas
 */
public class CustomHistogramDataset extends HistogramDataset{
    public String toTable(double intervalLength){
        double inc = (double)intervalLength/2;
        NumberFormat nr = Utilities.numberFormatter;  
        StringBuilder sb= new StringBuilder("QualityBin Interval\tFrequency").append(Utilities.ls);
        int n = this.getItemCount(0);
        String inter;
        for(int i =0; i< n; i++){
            //inter ="("+String.valueOf(nr.format(Math.floor(this.getXValue(0, i)-inc)))+"-"+String.valueOf(nr.format(Math.ceil(this.getXValue(0, i)+inc)))+"]";
            inter ="["+String.valueOf(nr.format(this.getXValue(0, i)-inc))+", "+String.valueOf(nr.format(this.getXValue(0, i)+inc))+(i==(n-1)?"]":")");
            //sb.append(this.getXValue(0, i)).append("\t").append(nr.format(this.getYValue(0, i))).append(Utilities.ls);
            sb.append(inter).append("\t").append(nr.format(this.getYValue(0, i))).append(Utilities.ls);
        }
        
        return sb.toString();
    }
//    public String toTable(){
//        return toTable(10);
//    }
    
}
