package org.fda.graphdrawing.data;

import java.util.Collections;
import java.util.List;
/**
 *
 * @author Linlin.Zhao
 */

public class CategoryLineChartDatasetSeries {
    private List<String> xList;
    private List<Double> yList;
    private String serieName;
    private int size;
    private double yMax=0;
    
    public CategoryLineChartDatasetSeries(String sn, List<String> x, List<Double> y){
        this.xList = x;
        this.yList = y;
        this.serieName = sn;
        if(this.xList.size()==this.yList.size()){
            this.size = this.yList.size();
        }
        else{
            this.size = 0;
        }
        if(x.isEmpty()||y.isEmpty()){
            this.yMax = 0;
        }
        else{
        this.yMax = Collections.max(y);
        }
    }
    
    public List<String> getXlist(){
        return xList;
    }
    
    public List<Double> getYlist(){
        return yList;
    }
    
    public String getSerieName(){
        return serieName;
    }
    public int getSize(){
        return this.size;
    }
    public double getYMax(){
        return this.yMax;
    }
}
