package org.fda.evaluator;

/**
 *
 * @author Gokhan.Yavas
 */
public class QLPair implements Comparable<QLPair>{
    private final long length;
    private final double quality;
    public QLPair(long length, double quality){
        this.length = length;
        this.quality = quality;        
    }

    public long getLength() {
        return length;
    }

    public double getQuality() {
        return quality;
    }

    @Override
    public int compareTo(QLPair o) {
        if(this.quality!=o.quality){
            if(this.quality > o.quality)
                return 1;
            else
                return -1;
        }
        else {
            return (int) (this.length - o.length);
        }
    }
    
}
