
package org.fda.data;

import java.util.concurrent.TimeUnit;

/**
 *
 * @author Gokhan.Yavas
 */
public class TimePoint implements Comparable<TimePoint>{
    private long start, end;
            
    private String label;   
    public TimePoint(String label, long start){
        this.label = label;
        this.start = start;
       
    }
    public String getLabel(){
        return label;
    }
    public long getStart(){
        return start;
    }
    public long getEnd(){
        return end;
    }
    public void setEnd(long end){
        this.end=end;
    }
    @Override
    public int compareTo(TimePoint o) {
        if(end<o.end)
            return 1;
        else if(end>o.end)
            return -1;
        else 
            return 0;
    }
    @Override
    public String toString(){
        String lb;
        if(!label.equalsIgnoreCase(Utilities.cmd_key_word))
            lb = "Duration of "+label+"(in sec):\t";
        else
            lb = "Total time(in sec):\t";
        return lb+TimeUnit.NANOSECONDS.toSeconds(end-start);        
    }
}
