
package org.fda.data;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.fda.data.Enums.FileMode;
import org.fda.inputdataparser.FastaWriter;
import org.fda.inputdataparser.ReadRecord;
import java.io.Serializable;
import java.util.Objects;


/**
 *
 * @author Gokhan.Yavas
 */
 public class ReferenceFile implements Comparable<ReferenceFile>, Serializable{
    private final File file;
    private final List<Reference> references;
    private final FastaWriter fw;
    private static final long serialVersionUID = 112411362619L;
    private FileMode mode;
//    public String getPrefix(){
//        return file.getName().split("\\.")[0];
//    }
    public File getFile(){
        return file;
    }
    public void closeFastaWriter(){
        fw.closeWriter();
    }
    public String getAbsolutePath(){
        return this.file.getAbsolutePath();
    }
    public List<Reference> getReferences(){
        return references;
    }
    public void addReference(Reference r){
        references.add(r);
    }
    public ReferenceFile(String filename, FileMode m){
        this.file = new File(filename);        
        references = new ArrayList();
        this.mode = m;
        if(mode==FileMode.WRITE)
            this.fw = new FastaWriter(file);
        else
            this.fw = null;
    }
    public ReferenceFile(File f, FileMode m){
        this.file = f;                
        references = new ArrayList();
        this.mode = m;
        if(mode==FileMode.WRITE)
            this.fw = new FastaWriter(file);
        else
            this.fw = null;
        
    }
    public void writeTo(ReadRecord r){
        fw.write(r);
    }
    public long getSize(){
        return fw.getSize();
    }
    @Override
    public int compareTo(ReferenceFile o) {
        return this.file.getName().compareToIgnoreCase(o.getFile().getName());
    }
    @Override
    public int hashCode(){
        return file.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final ReferenceFile other = (ReferenceFile) obj;
        if (!Objects.equals(this.file, other.file)) {
            return false;
        }
        return true;
    }
    
}
