package org.fda.data;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author Gokhan.Yavas
 */
public class QUALLEVEL {
    
    private final BigDecimal highestValue;
    private final BigDecimal lowestValue;
    private final BigDecimal difference;
    private final QUAL highest;

    public QUAL getHighest() {
        return highest;
    }

    public QUAL getLowest() {
        return lowest;
    }
    private final QUAL lowest;
    private final List<QUAL> qlevels = new ArrayList<>();

    public List<QUAL> getQlevels() {
        return qlevels;
    }
    public QUALLEVEL(double highestValue, double lowestValue, double difference){
        this.highestValue = new BigDecimal(highestValue, new MathContext(2));        
        this.lowestValue = new BigDecimal(lowestValue, new MathContext(2));
        this.difference = new BigDecimal(difference, new MathContext(2));
        
        for(BigDecimal d=this.lowestValue; d.doubleValue()<=highestValue; d=d.add(this.difference)){
            qlevels.add(new QUAL(d));
        }        
        
        lowest=qlevels.get(0);
        highest = qlevels.get(qlevels.size()-1);                
        
        for(int i=1; i<qlevels.size(); i++)
            qlevels.get(i).setPrev(qlevels.get(i-1));
        for(int i=0; i<(qlevels.size()-1); i++)
            qlevels.get(i).setNext(qlevels.get(i+1));
        
    }
    public List<QUAL> allValidLevels(double d){
        List<QUAL> ret = new ArrayList<>();
        for(int i=0; i<qlevels.size(); i++){
            if(d>=qlevels.get(i).getValue()){
                ret.add(qlevels.get(i));
            }
        }
        return ret;
    }         
    public static void main(String[] args){
        for(QUAL q : Utilities.qlevel.getQlevels()){
            System.out.println(q.getValue());
        }
    }
}
