package org.fda.data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 *
 * @author Gokhan.Yavas
 */
public class QUAL implements Serializable, Comparable<QUAL>{
    private final BigDecimal value;
    private final double dvalue;
    
    private QUAL next=null;
    private QUAL prev=null;

    public double getValue() {
        return dvalue;
    }
    public QUAL getNext() {
        return next;
    }
    public QUAL getPrev() {
        return prev;
    }        
    public QUAL(BigDecimal value){          
        this.value = value;
        this.dvalue=value.doubleValue();
    }
    public void setNext(QUAL next){
        this.next = next;
    }
    public void setPrev(QUAL prev){
        this.prev = prev;
    }

    @Override
    public int compareTo(QUAL o) {
        if(this.getValue() > o.getValue())
            return 1;
        else if (this.getValue() < o.getValue())
            return -1;
        else 
            return 0;
    }
    
    
}
