
package org.fda.data;
import java.io.File;
import java.io.Serializable;
/**
 *
 * @author Gokhan.Yavas
 */
public class Enums {
    public enum HashingAlgorithm{
        MD5("MD5"), SHA_1("SHA-1"), SHA_256("SHA-256");
        private final String algorithm;
        private HashingAlgorithm(String algorithm) {
            this.algorithm = algorithm;
        }
        @Override
        public String toString(){
            return algorithm;
        }
        
    }
    
    public enum AcceptedInputFileTypes{
        FASTQ("fastq"), FA("fa"), FASTA("fasta"), FASTAGZ("fasta.gz"), FAGZ("fa.gz"), FASTQGZ("fastq.gz");
        private final String file_extension;

        private AcceptedInputFileTypes(String extension) {
            this.file_extension = extension;
        }
        @Override
        public String toString(){
            return file_extension;
        }
    }
    public enum AlignmentTool{
        minimap2, nucmer;
        public String getFileExtension(){
            return this==minimap2 ? ".paf" : ".delta";
        }
        public String getFolder(){
            return this==minimap2 ? "minimap2" : "mummer";            
        }
        public String[] getExec(){
            return this==minimap2 ? new String[]{"minimap2"} : new String[]{"show-diff",  "promer", "nucmer",
            "exact-tandems", "dnadiff", "show-snps", "show-tiling", "show-coords", "show-aligns", "repeat-match", "mgaps", 
            "delta-filter", "combineMUMs", "mummer", "annotate"};
        }
        public String[] getCompileCommand(File alignerDir){
            String[] allcmds;
            if(this == nucmer){
                String cdcmd = "cd "+alignerDir.getAbsolutePath();                
                String configcmd = "./configure --prefix="+alignerDir.getAbsolutePath();
                String makecmd = "make";                
                allcmds = new String[]{"/bin/sh", "-c", cdcmd+";"+configcmd+";"+makecmd};                                
            }
            else{
                String makecmd = "make -C " + alignerDir.getAbsolutePath();
                allcmds = new String[]{makecmd};                
            }
            return(allcmds);
        }
    }

    public enum STOPOBJECT{
        STOP;
    }
    public enum Inconsistency implements Serializable{
        TRANSLOCATION, RELOCATION, INVERSION, SCAFFOLD_GAP ;        
        private static final long serialVersionUID = -11004102182489L;
        public static String[] getValues(){            
            return new String[]{"TRANSLOCATION", "RELOCATION", "INVERSION", "SCAFFOLD_GAP"};
        }
    }
        
    public enum Orientation implements Serializable{
        F('+'), R('-');
        private final char o;
        private static final long serialVersionUID = 911004102182489L;
        Orientation(char o){
            this.o = o;
        }
        public char getCharRepresentation(){
            return o;
        }
    }
    public enum Base {
        A, C, T, G;
        public Base complement(){
            switch(this){
                case A:
                    return T;                    
                case T:
                    return A;                    
                case C:
                    return G;                    
                case G:
                    return C;                    
            }   
            return null;
        }
    }        
    public enum RunCommand {
        ContigGenerate1, ContigGenerate2, ContigGenerate3, ContigGenerate4, ContigGenerate5, AssemblyReevaluate, AssemblyAlignAndEvaluate, ComputeModel, ChrPick, RecomputeModel, ShowModel, Filter, Misassemble;    
    }    
    
    public enum NGLevel implements Serializable{
        NG10(10), NG20(20), NG30(30), NG40(40), NG50(50), NG60(60), NG70(70), NG80(80), NG90(90), NG100(100);
        private final double threshold;
        private static final long serialVersionUID = 82489L;
        NGLevel(double thr){
            this.threshold = thr;
        }
        public double getThreshold(){
            return threshold;
        }
        public NGLevel nextLevel(){
            if(this == NG100)
                return null;
            return NGLevel.valueOf("NG"+((int)getThreshold()+10));
        }
        public NGLevel prevLevel(){
            if(this == NG10)
                return null;
            return NGLevel.valueOf("NG"+((int)getThreshold()-10));
        }
        
    } 
    public enum LGLevel implements Serializable{
        LG10(10), LG20(20), LG30(30), LG40(40), LG50(50), LG60(60), LG70(70), LG80(80), LG90(90), LG100(100);
        private final double threshold;
        private static final long serialVersionUID = 82489L;
        LGLevel(double thr){
            this.threshold = thr;
        }
        public double getThreshold(){
            return threshold;
        }
        public LGLevel nextLevel(){
            if(this == LG100)
                return null;
            return LGLevel.valueOf("LG"+((int)getThreshold()+10));
        }        
        public LGLevel prevLevel(){
            if(this == LG10)
                return null;
            return LGLevel.valueOf("LG"+((int)getThreshold()-10));
        }        
        
    } 
    public enum LLevel implements Serializable{
        L10(10), L20(20), L30(30), L40(40), L50(50), L60(60), L70(70), L80(80), L90(90), L100(100);
        private final double threshold;
        private static final long serialVersionUID = 82489L;
        LLevel(double thr){
            this.threshold = thr;
        }
        public double getThreshold(){
            return threshold;
        }
        public LLevel nextLevel(){
            if(this == L100)
                return null;
            return LLevel.valueOf("L"+((int)getThreshold()+10));
        }        
        public LLevel prevLevel(){
            if(this == L10)
                return null;
            return LLevel.valueOf("L"+((int)getThreshold()-10));
        }        
        
    } 
    
    public enum NLevel implements Serializable{
        N10(10), N20(20), N30(30), N40(40), N50(50), N60(60), N70(70), N80(80), N90(90), N100(100);
        private final double threshold;
        private static final long serialVersionUID = 82489L;
        NLevel(double thr){
            this.threshold = thr;
        }
        public double getThreshold(){
            return threshold;
        }
        public NLevel nextLevel(){
            if(this == N100)
                return null;
            return NLevel.valueOf("N"+((int)getThreshold()+10));
        }   
        public NLevel prevLevel(){
            if(this == N10)
                return null;
            return NLevel.valueOf("N"+((int)getThreshold()-10));
        }   
        public static NLevel minLevel(){
            return N10;
        }
        public static NLevel maxLevel(){
            return N100;
        }
        
    }     
    public enum CoverageType implements Serializable{
        FULL, PARTIAL, NONE;
        private static final long serialVersionUID = 28411611902182489L;
        public static CoverageType getCoverageType(double overlap){        
            if(overlap==100)
                return FULL;
            else if(overlap==0)
                return NONE;
            else 
                return PARTIAL;
        }
    }
//    public enum InputDataType {
//        Contig("Reference"), Read("Contig");
//        private final String to;
//        InputDataType(String to){
//            this.to = to;
//        }
//        public String getTo(){
//            return to;
//        }
//    }
    public enum FileMode implements Serializable{
        READONLY, WRITE;
        private static final long serialVersionUID = 35902182489L;
    }
    public enum RunMode {
        merge, split;    
    }
    public enum GeneFormat {
        GFFV3, TAB_UCSC, GTF, TMP;    
    }
    
    public enum ScriptRunMode{        
        //none("none"), sbatch("sbatch"), qsub("qsub"), multithread("multithread"); 
        sbatch("sbatch"), qsub("qsub"), multithread("multithread"); 
        private final String cmd;
        ScriptRunMode(String cmd){
            this.cmd = cmd;
        }
    }
//    public enum ModelComputeMode{        
//        
//        sim_data("sim_data"), primary_chr("primary_chr"), all("all"); 
//        private final String cmd;
//        ModelComputeMode(String cmd){
//            this.cmd = cmd;
//        }
//    }
    
    public enum CoordType {
        START, END, BOTH;
    }
    public enum Distribution {
        NORMAL, GAMMA, UNIFORM;
    }
//    public enum AssemblyType {
//        SCAFFOLD, CONTIG ;
//    }
    
}
