package org.fda.contiggenerator;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.fda.data.Enums;
import org.fda.data.Utilities;
import org.fda.exceptions.IllegalIntervalException;
import org.fda.inputdataparser.FastaReader;
import org.fda.inputdataparser.FastaRecord;
import org.fda.inputdataparser.FastaWriter;
import org.fda.intervaltree.Interval;

/**
 *
 * @author Gokhan.Yavas
 */
public class ContigGeneratorForModel extends ContigGenerator4{
    private final Map<String, List<String>> map;

    public Map<String, List<String>> getRefContigIDMap() {
        return map;
    }
    public ContigGeneratorForModel(File infile, File outfile){//, double mean, double sd, Enums.Distribution dist, boolean setseed, boolean isRandom, boolean createreport){
        super(infile, outfile, 0, 0, Enums.Distribution.UNIFORM, true, false, false);               
        map = new TreeMap();
    }
    @Override
    public void addRefAsContigs(){        
        FastaReader fr = new FastaReader();
        FastaWriter frw = new FastaWriter(outfile, true);        
        ContigDetails tmp;
        try{
            fr.openFile(infile);
            FastaRecord r;
                                                
            while((r=((FastaRecord)fr.readNextRecord()))!=null){
                //r.setName(r.getName()+Utilities.primaryChromosomeSuffix);
                frw.write(r);
                //lengths.add(r.getReadRecordLength());
                
                totsize+=r.getReadRecordLength();
                totalN+=r.getNcount();
                totcontnumber++;
                tmp = new ContigDetails(r.getName(), r.getName(), new Interval(1, r.getReadRecordLength(), false), Enums.Orientation.F, r.getNcount(), r.getNratio());
                finalcontigcoords.add(tmp);
                add2Lengths(tmp);
                map.get(r.getName()).add(r.getName());
            }
            fr.closeReader();
        }
        catch(IOException io){
            io.printStackTrace();
        } 
        catch (IllegalIntervalException ex) { 
            ex.printStackTrace();
        } 
        finally{
            frw.closeWriter();
        }
        report();        
    }    
    
    @Override
    public void generateContigs(){
        FastaReader fr = new FastaReader();
        FastaWriter frw = new FastaWriter(outfile);   
        
        try{
            fr.openFile(infile);
            FastaRecord r;
                                                
            while((r=((FastaRecord)fr.readNextRecord()))!=null){
//                if(r.getReadRecordLength()<Utilities.simulation_mincontiglength){
//                    System.out.println("This reference chromosome is smaller than "+Utilities.simulation_mincontiglength+" base pairs, which is the minimum required length");
//                    System.out.println("Hence no contigs would be created using this reference chromosome");
//                    continue;
//                }
                // calculate the total gaps in reference r
                totalNReference+=r.getNcount();
                
                totrefnumber++;
                totrefsize+=r.getReadRecordLength();
                map.put(r.getName(), new ArrayList());
                // now we read the reference sequence and create contigs to cover it "coverage" times                                    
                for(int i=0; i<Utilities.depthCoverage;i++){
                    if(setseed)
                        rand.setSeed((long)r.getReadRecordLength()+i);
                    setMean((double)r.getReadRecordLength());
                    map.get(r.getName()).addAll(createContigsOnReference(r, frw, 1));
                }
            }            
        }
        catch(IOException io){io.printStackTrace();} 
        catch (IllegalIntervalException ex) {ex.printStackTrace();}
        finally{
            frw.closeWriter();
        }
        report();
        
    }
    
}
