package org.fda.contiggenerator;

import org.fda.data.Enums;
import org.fda.data.Utilities;
import org.fda.intervaltree.Interval;

public class ContigDetails{
        private final Enums.Orientation or;
        private final String refname;
        private final String name;
        private final int ncount;

        public int getNcount() {
            return ncount;
        }

        public double getNratio() {
            return nratio;
        }
        private final double nratio;
        
        public String getName() {
            return name;
        }

        public Enums.Orientation getOr() {
            return or;
        }

        public Interval getIr() {
            return ir;
        }
        public String getRefname() {
            return refname;
        }
        private final Interval ir;
        ContigDetails(String name, String refname, Interval ir, Enums.Orientation or, int ncount, double nratio){
            this.name = name;
            this.or = or;
            this.ir = ir;
            this.refname = refname;
            this.ncount = ncount;
            this.nratio = nratio;
        }
        public String toString(){            
            return name+"\t"+refname+":"+ir.getlow()+"-"+ir.gethigh()+"\t"+or+"\t"+ir.getlength()+"\t"+ncount+"\t"+Utilities.numberFormatter.format(nratio);
        }
    }            
