package org.fda.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.converters.FileConverter;
import java.io.File;
import org.fda.data.Enums;
import org.fda.functionality.AlphaValidator;

/**
 *
 * @author Gokhan.Yavas
 */
@Parameters(commandDescription = "Recompute the model based on the model filter coefficient")
public class RecomputeModelCommand extends Command{
    @Parameter(names = {"-i"}, description = "Input model file", required = true, converter = FileConverter.class)            
    protected File inputFile;
    @Parameter(names = {"-o"}, description = "Recomputed model file", required = true, converter = FileConverter.class)            
    protected File outFile;
    
    protected File destinationFolder=new File(System.getProperty("user.dir"));
    public RecomputeModelCommand(){
        this.rcmd = Enums.RunCommand.RecomputeModel;
    }
    public File getInputFile() {
        return inputFile;
    }
    public File getOutFile() {
        return outFile;
    }
}
