package org.fda.commands;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.converters.FileConverter;
import com.beust.jcommander.validators.PositiveInteger;
import java.io.File;
import org.fda.data.Enums;
import org.fda.data.Enums.RunCommand;
import org.fda.data.Utilities;


/**
 *
 * @author Gokhan.Yavas
 */
@Parameters(commandDescription = "Misassemble command. This command introduces a given number of misassemblies to each contig in the given assembly. The misassembly threshold is "
        + "specified by the user ")
public class MisassembleCommand extends Command{

    public MisassembleCommand() {
        rcmd = RunCommand.Misassemble;
    }
    @Parameter(names = {"-f","--infile"}, description = "Input assembly file", required = true, converter = FileConverter.class)            
    protected File inputFile;
    @Parameter(names = {"-o","--outfile"}, description = "Output assembly file", required = false, converter = FileConverter.class)            
    protected File outputFile=new File("misassembled.fa");
    @Parameter(names = {"-m","--misthre"}, description = "Misassembly threshold", required = false, validateWith = PositiveInteger.class)            
    protected int mis_thre= Utilities.alignmentDistanceThreshold;
    @Parameter(names = {"-n","--avgmisassembly"}, description = "Number of misassemblies induced per contig", required = true, validateWith = PositiveInteger.class)            
    protected int avgmisassembly;

    protected File destinationFolder=new File(System.getProperty("user.dir"));    

    public File getDestinationFolder() {
        return destinationFolder;
    }
    
    public File getInputFile() {
        return inputFile;
    }

    public void setInputFile(File inputFile) {
        this.inputFile = inputFile;
    }

    public File getOutputFile() {
        return outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public int getMis_thre() {
        return mis_thre;
    }

    public void setMis_thre(int mis_thre) {
        this.mis_thre = mis_thre;
    }

    public int getAvgmisassembly() {
        return avgmisassembly;
    }

    public void setAvgmisassembly(int avgmisassembly) {
        this.avgmisassembly = avgmisassembly;
    }
    
    
    
}
