/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.fda.basicstats;

import java.io.Serializable;
import org.fda.intervaltree.IntervalSearchTree;

/**
 *
 * @author Gokhan.Yavas
 */
public class ContigRecord implements Comparable<ContigRecord>, Serializable{
    private final int length;
    private final int gc_count;    
    private final String contigName;
    private final int n_count;
    private static final long serialVersionUID = -15925739L;
    private final byte[] hashValue;
    private final byte[] seqHashValue;
    private final IntervalSearchTree ist;

    public IntervalSearchTree getGapIntervals() {
        return ist;
    }
    public ContigRecord(String contigName, int length, int gc_count, int n_count, byte[] hashV, byte[] seqHashV, IntervalSearchTree ist){
        this.contigName = contigName;
        this.length = length;
        this.gc_count = gc_count;
        this.n_count = n_count;
        this.hashValue = hashV;
        this.seqHashValue=seqHashV;
        this.ist = ist;
    }

    public byte[] getHashValue() {
        return hashValue;
    }
    public String getContigName(){
        return contigName;
    }
    public int getLength(){
        return length;
    }

    public byte[] getSeqHashValue() {
        return seqHashValue;
    }
    public int getGCCount(){
        return gc_count;
    }
    public int getNCount(){
        return n_count;
    }

    @Override
    public int compareTo(ContigRecord o) {
        return this.length - o.getLength();
    }
    
}
