package org.fda.alignmentparser.paf;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.fda.data.ReferenceSet;

/**
 *
 * @author Gokhan.Yavas
 */
public class PafFileReader {
    private BufferedReader br;    
    private String header = null;
    private ReferenceSet chrset;    
    private long recordnumber=0;
    public PafFileReader(){
        
    }
    public void openFile(File f, ReferenceSet c) throws FileNotFoundException, IOException{        
        chrset = c;
        br = new BufferedReader(new FileReader(f));
    }
    public void closeReader() throws FileNotFoundException, IOException{
        br.close();
    }
    public PafRecord readNextPafRecord(){
        String line;
        PafRecord pr=null;
        try{                        
            while((line = br.readLine())!=null){
                line = line.trim();
                if(line.isEmpty()){            
                    continue;
                }
                pr = new PafRecord(line, chrset);                
                recordnumber++;
                break;                
            }
        }
        catch(Exception e){e.printStackTrace();}
        return pr;
        
    }
    
}
