package org.fda.alignmentparser.delta;

import java.util.ArrayList;
import java.util.List;
import org.fda.alignment.Alignment;
import org.fda.alignment.NucmerAlignment;
import org.fda.data.Reference;
import org.fda.data.Utilities;
import org.fda.exceptions.IllegalIntervalException;

/**
 *
 * @author Gokhan.Yavas
 */
public class DeltaRecord {
    private final Reference refID;
    private final String contigID, deltaRecString;
    private final int contigLength,refChrLength;
    private final List<Alignment> alignments;
    public DeltaRecord(Reference refID, String contigID, String deltaRecString, int contLength, int refLength){
        this.refID = refID;
        this.contigID = contigID;
        this.deltaRecString = deltaRecString;
        this.contigLength = contLength;
        this.refChrLength = refLength;
        this.alignments = setAlignmentsWDelta();
        
    }
    public List<Alignment> getAlignments(){
        return this.alignments;
    }
    public int getRefChrLength(){        
        return this.refChrLength;
    }
    public int getContigLength(){
        return this.contigLength;
    }
    public Reference getRefID(){
        return refID;
    }
    public String getContigID(){
        return contigID;
    }
    public String getDeltaRecStr(){
        return deltaRecString;
    }

    private List<Alignment> setAlignmentsWDelta(){
        List<Alignment> al = new ArrayList();
        // parse the delta string and get the set of alignments 
        String[] arr = deltaRecString.split(Utilities.ls);
        int[] deltaArr=null;
        String[] alDetails;
        int i=0;
        int startPoint, endPoint;
        
        int total, tmpInd;
        int idc, simc, stpc;
        double id, sim, stp;
        while(true){
            startPoint = i;
            while(!arr[i].equalsIgnoreCase("0")){
                i++;
            }
            endPoint = i;
            
            if(endPoint>=startPoint){                
                alDetails = arr[startPoint].split("\\s+");
                startPoint++;
                total = Math.abs(Integer.parseInt(alDetails[0])- Integer.parseInt(alDetails[1]))+1;
                idc = Integer.parseInt(alDetails[4]);
                simc = Integer.parseInt(alDetails[5]);
                stpc = Integer.parseInt(alDetails[6]);
                if(endPoint>startPoint){
                    deltaArr = new int[endPoint-startPoint];
                    tmpInd=0;
                    for(int j=startPoint; j<endPoint; j++){
                        deltaArr[tmpInd]=Integer.parseInt(arr[j]);
                        total++;
                        tmpInd++;
                    }
                }
                else{
                    deltaArr = null;                    
                }
                id = (double)(total-idc)/(double)total * 100;
                sim = (double)(total-simc)/(double)total * 100;
                stp = (double)stpc/(double)(total*2) * 100;

                try{
                    al.add(new NucmerAlignment(refID, 
                            Integer.parseInt(alDetails[0]), Integer.parseInt(alDetails[1]), Integer.parseInt(alDetails[2]), Integer.parseInt(alDetails[3]), 
                            idc, simc, stpc, id, sim, stp, deltaArr));
                }
                catch(IllegalIntervalException ex){/*Do nothing, just skip this alignment in the delta file*/}
            }            
            if(i>=(arr.length-1))
                break;
            i++;
        }
        return al;
    }
}
