
package org.fda.alignmentparser.delta;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import org.fda.alignment.ScaffoldContig;
import org.fda.alignmentparser.AlignmentReaderRunnable;
import org.fda.basicstats.ContigRecord;
import org.fda.data.ReferenceSet;
import org.fda.data.Utilities;

/**
 *
 * @author Gokhan.Yavas
 */
public class DeltaReaderRunnable extends AlignmentReaderRunnable{
    private final DeltaFileReader dfr;  
    private final File sourceFolder;
    
    public DeltaReaderRunnable(BlockingQueue inqueue, BlockingQueue outqueue, ReferenceSet ch, int no, File sourceFolder){       
        super(inqueue, outqueue, ch, no);
        dfr = new DeltaFileReader();
        this.sourceFolder = sourceFolder;
    }

    protected void process(List<File> filelist){
        Set<String> asc= new HashSet();
        DeltaRecord dr;
        ScaffoldContig as ;        
        Map<String, ScaffoldContig> alignmentCollection = new HashMap(); 
        Map<String, ContigRecord> contigs=null;
        ObjectInputStream input=null;
        try{
            input = new ObjectInputStream(new BufferedInputStream(new FileInputStream(new File(sourceFolder.getAbsolutePath()+File.separator+Utilities.contigObjFile))));
            contigs = (Map<String, ContigRecord>)input.readObject();
            
            for(File f : filelist){
                dfr.openFile(f, chrset);
                while((dr=dfr.readNextDeltaRecord())!=null){
                    asc.add(dr.getContigID());
                    if(alignmentCollection.containsKey(dr.getContigID()))
                        alignmentCollection.get(dr.getContigID()).addAlignments(dr.getAlignments());
                    else{
                        as = new ScaffoldContig(dr.getContigID(), dr.getContigLength());
                        as.addAlignments(dr.getAlignments());
                        as.setHashValue(contigs.get(dr.getContigID()).getHashValue());
                        as.setSeqHashValue(contigs.get(dr.getContigID()).getSeqHashValue());
                        as.setGCCount(contigs.get(dr.getContigID()).getGCCount());
                        as.setGapIntervalTree(contigs.get(dr.getContigID()).getGapIntervals());
                        as.setNCount(contigs.get(dr.getContigID()).getNCount());                        
                        alignmentCollection.put(dr.getContigID(), as);
                    }
                }
                dfr.closeReader();
            }            
            //System.out.println(filelist.get(0).getParentFile().getAbsolutePath());
            for(String contID : asc){
                outqueue.put(alignmentCollection.get(contID));                                               
            }            
        }
        catch(ClassNotFoundException e){e.printStackTrace();}
        catch (IOException ex) {
            if(!(ex instanceof EOFException))
                ex.printStackTrace();
        } 
        catch (InterruptedException ex) {            
            ex.printStackTrace();
        }            
        finally {
            try {
                input.close();
            } catch (IOException ex) {
                    ex.printStackTrace();                    
            }
        }                            
    }
    
}
