package org.fda.alignmentparser;

import java.io.File;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import org.fda.data.ReferenceSet;

/**
 *
 * @author Gokhan.Yavas
 */
public abstract class AlignmentReaderRunnable implements Runnable{

    protected final BlockingQueue inqueue;
    protected final BlockingQueue outqueue;
    protected final ReferenceSet chrset; 
    protected final String id;     
    
    public AlignmentReaderRunnable(BlockingQueue inqueue, BlockingQueue outqueue, ReferenceSet ch, int no){
        this.inqueue = inqueue;
        this.outqueue = outqueue;             
        chrset = ch;
        id = "Reader"+no;        
    }

    protected abstract void process(List<File> filelist);
    @Override
    public void run() {
        Object filelist;
        while(true){
            try{
                filelist = inqueue.take();
                if(filelist instanceof List){                    
                    process((List<File>)filelist);                    
                }
                else{
                    break;
                }
            }
            catch(Exception ex){/* Do nothing about it*/ ex.printStackTrace();}            
        }
    }
    
}
