/*
 * Decompiled with CFR 0.152.
 */
package org.fda.regression;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.fda.data.Reference;
import org.fda.data.ReferenceSet;
import org.fda.data.Utilities;
import org.fda.regression.DataValue;
import org.fda.regression.RegressionSubModel;

public class RegressionModel
implements Serializable {
    private final Map<Reference, RegressionSubModel> rmap = new TreeMap<Reference, RegressionSubModel>();
    private final ReferenceSet rset;
    private final Map<Reference, List<DataValue>> alldatamap;
    private static final long serialVersionUID = -324363750582918L;

    public RegressionSubModel getSubModel(Reference r) {
        return this.rmap.get(r);
    }

    public Map<Reference, List<DataValue>> getAlldatamap() {
        return this.alldatamap;
    }

    public RegressionModel(ReferenceSet rset, Map<Reference, List<DataValue>> alldata) {
        this.rset = rset;
        this.alldatamap = alldata;
    }

    public boolean addSubModel(Reference r, RegressionSubModel mod) {
        if (this.rset.findReference(r.getRefID()) != null) {
            this.rmap.put(r, mod);
            return true;
        }
        return false;
    }

    public ReferenceSet getReferenceSet() {
        return this.rset;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder("Total " + this.rset.getRefs().size() + " chromosomes in the reference:" + Utilities.ls);
        if (Utilities.showModelInTabularFormat) {
            ret.append("Chromosome\tLength Coeff\tRelocaction Threshold Coeff\tIntercept" + Utilities.ls);
        }
        for (Reference ref : this.rset.getRefs()) {
            ret.append(ref.getRefID() + "\t");
            if (Utilities.showModelInTabularFormat) {
                ret.append(this.rmap.get(ref).toString());
            } else {
                ret.append(this.rmap.get(ref).inTabDelimFormat());
            }
            if (!Utilities.showModelData) continue;
            ret.append("\tName\tLength\tThreshold\tMisassembly" + Utilities.ls);
            List<DataValue> dlist = this.alldatamap.get(ref);
            for (DataValue d : dlist) {
                ret.append("\t" + d + Utilities.ls);
            }
        }
        return ret.toString();
    }
}

