/*
 * Decompiled with CFR 0.152.
 */
package org.fda.regression;

import java.io.File;
import org.fda.commands.ComputeModelCommand;
import org.fda.contiggenerator.ContigGeneratorForModel;
import org.fda.data.Enums;
import org.fda.data.ReferenceSet;
import org.fda.data.Utilities;
import org.fda.dataaligner.DataAligner;
import org.fda.evaluator.Evaluator4Artifact;
import org.fda.regression.RegressionModel;

public class ModelCompute {
    private final File destFolder;
    private final File refFile;
    private final ReferenceSet chrset;
    private File modelFile;

    public File getModelFile() {
        return this.modelFile;
    }

    public ModelCompute(File outfolder, File reffile, ReferenceSet chrset) {
        this.destFolder = outfolder;
        this.refFile = reffile;
        this.chrset = chrset;
    }

    public RegressionModel process(File alignerDir, boolean justModelling) {
        File modelDir = new File(this.destFolder.getAbsolutePath() + File.separator + "MODEL");
        modelDir.mkdirs();
        Utilities.current_cmd.startTimer4Process("Generating the synthetic contigs");
        File simFile = new File(modelDir.getAbsolutePath() + File.separator + "sim.fa");
        ContigGeneratorForModel g = new ContigGeneratorForModel(this.refFile, simFile);
        g.generateContigs();
        g.addRefAsContigs();
        int noparts = Utilities.alignmentTool == Enums.AlignmentTool.nucmer ? Math.min(200, Math.max(1, g.getTotcontnumber() / 10)) : 1;
        Utilities.current_cmd.endTimer4Process("Generating the synthetic contigs");
        Utilities.current_cmd.startTimer4Process("Aligning the reference and synthetic contigs back to reference");
        File tmpdivideDestFolder = new File(modelDir.getAbsolutePath() + File.separator + "CONTIG_ALIGNMENTS");
        tmpdivideDestFolder.mkdirs();
        DataAligner d = new DataAligner(simFile, noparts, tmpdivideDestFolder, alignerDir, this.chrset);
        int n = d.setAligners(justModelling);
        if (n < 0) {
            return null;
        }
        Utilities.waiter(d.getTouchFiles());
        Utilities.current_cmd.endTimer4Process("Aligning the reference and synthetic contigs back to reference");
        Utilities.current_cmd.startTimer4Process("Multiple Linear Model Computation for artifact prediction");
        Evaluator4Artifact e4m = Utilities.current_cmd.getClass().isInstance(ComputeModelCommand.class) ? new Evaluator4Artifact(tmpdivideDestFolder, this.destFolder, this.chrset, g.getRefContigIDMap(), new File(this.destFolder.getAbsolutePath() + File.separator + "model.bin")) : new Evaluator4Artifact(tmpdivideDestFolder, this.destFolder, this.chrset, g.getRefContigIDMap());
        e4m.process();
        RegressionModel rm = e4m.getRm();
        Utilities.current_cmd.endTimer4Process("Multiple Linear Model Computation for artifact prediction");
        Utilities.deleteFolder(modelDir);
        this.modelFile = e4m.getModelfile();
        return rm;
    }
}

