/*
 * Decompiled with CFR 0.152.
 */
package org.fda.intervaltree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.fda.intervaltree.Interval;
import org.fda.intervaltree.Node;

public class IntervalSearchTree
implements Serializable {
    private static final long serialVersionUID = 112414357102382689L;
    protected Node root;

    public Long inOrderPrint() {
        return this.inorderTraversal4Print(this.root);
    }

    private Long inorderTraversal4Print(Node n) {
        long toRet = 0L;
        if (n != null) {
            toRet += this.inorderTraversal4Print(n.left).longValue();
            if (n.interval instanceof Interval) {
                System.out.println(n.interval.toStringWSubIntervals());
            } else {
                System.out.println(n.interval.toString());
            }
            toRet += (long)n.interval.getlength();
            toRet += this.inorderTraversal4Print(n.right).longValue();
        }
        return toRet;
    }

    public List<Interval> inOrder() {
        ArrayList<Interval> list = new ArrayList<Interval>();
        this.inorderTraversal(this.root, list);
        return list;
    }

    private void inorderTraversal(Node n, List<Interval> list) {
        if (n != null) {
            this.inorderTraversal(n.left, list);
            list.add(n.interval);
            this.inorderTraversal(n.right, list);
        }
    }

    public boolean contains(Interval interval, List<Interval> emptyList) {
        return this.get(interval, emptyList) != null;
    }

    private Node get(Interval interval, List<Interval> emptyList) {
        return this.get(this.root, interval, emptyList);
    }

    private Node get(Node x, Interval interval, List<Interval> emptyList) {
        if (x == null) {
            return null;
        }
        int cmp = interval.compareTo(x.interval);
        if (cmp < 0) {
            return this.get(x.left, interval, emptyList);
        }
        if (cmp > 0) {
            return this.get(x.right, interval, emptyList);
        }
        emptyList.add(x.interval);
        return x;
    }

    public synchronized boolean put(Interval interval) {
        ArrayList<Interval> lst = new ArrayList<Interval>();
        if (!this.contains(interval, lst)) {
            this.root = this.randomizedInsert(this.root, interval);
            return true;
        }
        return false;
    }

    protected Node randomizedInsert(Node x, Interval interval) {
        if (x == null) {
            return new Node(interval);
        }
        if (Math.random() * (double)this.size(x) < 1.0) {
            return this.rootInsert(x, interval);
        }
        int cmp = interval.compareTo(x.interval);
        if (cmp < 0) {
            x.left = this.randomizedInsert(x.left, interval);
        } else {
            x.right = this.randomizedInsert(x.right, interval);
        }
        this.fix(x);
        return x;
    }

    private Node rootInsert(Node x, Interval interval) {
        if (x == null) {
            return new Node(interval);
        }
        int cmp = interval.compareTo(x.interval);
        if (cmp < 0) {
            x.left = this.rootInsert(x.left, interval);
            x = this.rotR(x);
        } else {
            x.right = this.rootInsert(x.right, interval);
            x = this.rotL(x);
        }
        return x;
    }

    private Node joinLR(Node a, Node b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (Math.random() * (double)(this.size(a) + this.size(b)) < (double)this.size(a)) {
            a.right = this.joinLR(a.right, b);
            this.fix(a);
            return a;
        }
        b.left = this.joinLR(a, b.left);
        this.fix(b);
        return b;
    }

    public boolean remove(Interval interval) {
        ArrayList<Interval> lst = new ArrayList<Interval>();
        Node n = this.get(interval, lst);
        this.root = this.remove(this.root, interval);
        return n != null;
    }

    private Node remove(Node h, Interval interval) {
        if (h == null) {
            return null;
        }
        int cmp = interval.compareTo(h.interval);
        if (cmp < 0) {
            h.left = this.remove(h.left, interval);
        } else if (cmp > 0) {
            h.right = this.remove(h.right, interval);
        } else {
            h = this.joinLR(h.left, h.right);
        }
        this.fix(h);
        return h;
    }

    public Interval search(Interval interval) {
        return this.search(this.root, interval);
    }

    private Interval search(Node x, Interval interval) {
        while (x != null) {
            if (interval.intersects(x.interval)) {
                return x.interval;
            }
            if (x.left == null) {
                x = x.right;
                continue;
            }
            if (x.left.max < interval.getlow()) {
                x = x.right;
                continue;
            }
            x = x.left;
        }
        return null;
    }

    public List<Interval> searchAll(Interval interval) {
        ArrayList<Interval> list = new ArrayList<Interval>();
        this.searchAll(this.root, interval, list);
        return list;
    }

    public boolean searchAll(Node x, Interval interval, List<Interval> list) {
        boolean found1 = false;
        boolean found2 = false;
        boolean found3 = false;
        if (x == null) {
            return false;
        }
        if (interval.intersects(x.interval)) {
            list.add(x.interval);
            found1 = true;
        }
        if (x.left != null && x.left.max >= interval.getlow()) {
            found2 = this.searchAll(x.left, interval, list);
        }
        if (found2 || x.left == null || x.left.max < interval.getlow()) {
            found3 = this.searchAll(x.right, interval, list);
        }
        return found1 || found2 || found3;
    }

    public int size() {
        return this.size(this.root);
    }

    private int size(Node x) {
        if (x == null) {
            return 0;
        }
        return x.N;
    }

    public int height() {
        return this.height(this.root);
    }

    private int height(Node x) {
        if (x == null) {
            return 0;
        }
        return 1 + Math.max(this.height(x.left), this.height(x.right));
    }

    private void fix(Node x) {
        if (x == null) {
            return;
        }
        x.N = 1 + this.size(x.left) + this.size(x.right);
        x.max = this.max3(x.interval.gethigh(), this.max(x.left), this.max(x.right));
    }

    private int max(Node x) {
        if (x == null) {
            return Integer.MIN_VALUE;
        }
        return x.max;
    }

    private int max3(int a, int b, int c) {
        return Math.max(a, Math.max(b, c));
    }

    private Node rotR(Node h) {
        Node x = h.left;
        h.left = x.right;
        x.right = h;
        this.fix(h);
        this.fix(x);
        return x;
    }

    private Node rotL(Node h) {
        Node x = h.right;
        h.right = x.left;
        x.left = h;
        this.fix(h);
        this.fix(x);
        return x;
    }

    public boolean check() {
        return this.checkCount() && this.checkMax();
    }

    private boolean checkCount() {
        return this.checkCount(this.root);
    }

    private boolean checkCount(Node x) {
        if (x == null) {
            return true;
        }
        return this.checkCount(x.left) && this.checkCount(x.right) && x.N == 1 + this.size(x.left) + this.size(x.right);
    }

    private boolean checkMax() {
        return this.checkMax(this.root);
    }

    private boolean checkMax(Node x) {
        if (x == null) {
            return true;
        }
        return x.max == this.max3(x.interval.gethigh(), this.max(x.left), this.max(x.right));
    }

    public static void main(String[] args) {
        IntervalSearchTree bst = new IntervalSearchTree();
        try {
            Interval a = new Interval(10, 20, false);
            Interval b = new Interval(10, 20, false);
            Interval c = new Interval(1, 2, false);
            bst.put(a);
            bst.put(b);
            bst.put(c);
            bst.remove(a);
            List<Interval> it = bst.searchAll(a);
            System.out.println(it.size());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

