/*
 * Decompiled with CFR 0.152.
 */
package org.fda.intervaltree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.fda.data.Enums;
import org.fda.exceptions.IllegalIntervalException;

public class Interval
implements Comparable<Interval>,
Serializable {
    protected List<Interval> subIntervals;
    private static final long serialVersionUID = 1901561012689L;
    protected int count = 0;
    protected int low;
    protected int high;
    protected int length;
    protected int overlap = 0;
    protected double overlapPercentage = 0.0;
    protected Enums.CoverageType cov_type = Enums.CoverageType.NONE;
    protected boolean merged;

    public Enums.CoverageType getCoverageType() {
        return this.cov_type;
    }

    public void setOverlap(int ov) {
        this.overlap = ov;
        this.overlapPercentage = 100.0 * (double)this.overlap / (double)this.length;
        this.cov_type = Enums.CoverageType.getCoverageType(this.overlapPercentage);
    }

    public int getOverlap() {
        return this.overlap;
    }

    public double getOverlapPercentage() {
        return this.overlapPercentage;
    }

    public boolean getMerged() {
        return this.merged;
    }

    public int getlow() {
        return this.low;
    }

    public int gethigh() {
        return this.high;
    }

    public int getlength() {
        return this.length;
    }

    public void setlow(int low) throws IllegalIntervalException {
        if (low > this.high || low <= 0) {
            throw new IllegalIntervalException("Illegal interval: " + low + "\t" + this.high + "\n");
        }
        this.low = low;
        this.length = this.high - low + 1;
    }

    public void sethigh(int high) throws IllegalIntervalException {
        if (high < this.low || high <= 0) {
            throw new IllegalIntervalException("Illegal interval: " + this.low + "\t" + high + "\n");
        }
        this.high = high;
        this.length = high - this.low + 1;
    }

    public int getDistance(Interval i) {
        if (this.intersects(i)) {
            return -1;
        }
        if (i.getlow() > this.gethigh()) {
            return i.getlow() - this.gethigh() - 1;
        }
        return this.getlow() - i.gethigh() - 1;
    }

    public static Interval getIntervalBetween(Interval i, Interval j) {
        if (!i.intersects(j) && i.getDistance(j) != 0) {
            try {
                if (j.getlow() > i.gethigh()) {
                    return new Interval(i.gethigh() + 1, j.getlow() - 1, false);
                }
                return new Interval(j.gethigh() + 1, i.getlow() - 1, false);
            }
            catch (IllegalIntervalException iie) {
                iie.printStackTrace();
            }
        }
        return null;
    }

    public void incrementCount() {
        ++this.count;
    }

    public int getCount() {
        return this.count;
    }

    public Interval(int left, int right, boolean merged) throws IllegalIntervalException {
        if (left > right || right <= 0 || left <= 0) {
            throw new IllegalIntervalException("Illegal interval: " + left + "\t" + right + "\n");
        }
        this.low = left;
        this.high = right;
        this.length = right - left + 1;
        this.merged = merged;
        this.subIntervals = new ArrayList<Interval>();
    }

    public int overlap(Interval id) {
        if (this.intersects(id)) {
            if (id.contains(this.high)) {
                if (id.contains(this.low)) {
                    return this.length;
                }
                return this.high - id.getlow() + 1;
            }
            if (id.contains(this.low)) {
                return id.high - this.low + 1;
            }
            return id.getlength();
        }
        return 0;
    }

    public boolean intersects(Interval that) {
        if (that.high < this.low) {
            return false;
        }
        return this.high >= that.low;
    }

    public boolean contains(int x) {
        return this.low <= x && x <= this.high;
    }

    @Override
    public int compareTo(Interval that) {
        if (this.low < that.low) {
            return -1;
        }
        if (this.low > that.low) {
            return 1;
        }
        if (this.high < that.high) {
            return -1;
        }
        if (this.high > that.high) {
            return 1;
        }
        return 0;
    }

    public List<Interval> getsubIntervals() {
        return this.subIntervals;
    }

    public boolean add2SubIntervals(Interval id) {
        return this.subIntervals.add(id);
    }

    public String toStringWSubIntervals() {
        return "[" + this.low + ", " + this.high + "] => " + this.subIntervalsToString();
    }

    public String subIntervalsToString() {
        StringBuilder str = new StringBuilder();
        String splitter = ",";
        Interval[] h = this.subIntervals.toArray(new Interval[0]);
        for (int i = 0; i < h.length; ++i) {
            Interval s = h[i];
            if (i == h.length - 1) {
                str.append(s);
                continue;
            }
            str.append(s + splitter);
        }
        return str.toString();
    }

    public String toString() {
        return "[" + this.low + ", " + this.high + "]";
    }

    public String toStringTabular() {
        return this.low + "\t" + this.high;
    }

    public static double MinRO(Interval i1, Interval i2) {
        int ov = i1.overlap(i2);
        return Math.min((double)ov / (double)i1.length, (double)ov / (double)i2.length);
    }

    public static double MinRO(Interval i1, List<Interval> ilist) {
        int ov = 0;
        for (Interval i : ilist) {
            ov += i1.overlap(i);
        }
        return Math.min((double)ov / (double)i1.length, (double)ov / (double)Interval.getTotalSize(ilist));
    }

    public static double MaxRO(Interval i1, Interval i2) {
        int ov = i1.overlap(i2);
        return Math.max((double)ov / (double)i1.length, (double)ov / (double)i2.length);
    }

    public static double MaxRO(Interval i1, List<Interval> ilist) {
        int ov = 0;
        for (Interval i : ilist) {
            ov += i1.overlap(i);
        }
        return Math.max((double)ov / (double)i1.length, (double)ov / (double)Interval.getTotalSize(ilist));
    }

    private static int getTotalSize(List<Interval> intlist) {
        int size = 0;
        for (Interval i : intlist) {
            size += i.getlength();
        }
        return size;
    }
}

