/*
 * Decompiled with CFR 0.152.
 */
package org.fda.inputdataparser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.fda.inputdataparser.ReadRecord;

public abstract class Reader {
    protected BufferedReader br;
    protected long readrecordnumber = 0L;
    protected Pattern gc_pattern = Pattern.compile("[GgCc]");

    public long getReadRecordNumber() {
        return this.readrecordnumber;
    }

    public void openFile(File f) throws FileNotFoundException, IOException {
        this.readrecordnumber = 0L;
        this.br = f.getName().endsWith(".gz") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(f)))) : new BufferedReader(new FileReader(f));
    }

    public void closeReader() throws FileNotFoundException, IOException {
        this.br.close();
    }

    public abstract ReadRecord readNextRecord();
}

