/*
 * Decompiled with CFR 0.152.
 */
package org.fda.inputdataparser;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.fda.data.Enums;
import org.fda.data.Utilities;
import org.fda.inputdataparser.FastaReader;
import org.fda.inputdataparser.FastqReader;
import org.fda.inputdataparser.ReadRecord;
import org.fda.inputdataparser.Reader;

public class InputReader {
    private long readrecordnumber = 0L;
    private Reader ir;

    public long getReadRecordNumber() {
        return this.readrecordnumber;
    }

    public void openFile(File f) throws FileNotFoundException, IOException, Exception {
        this.readrecordnumber = 0L;
        if (f.getName().endsWith(Enums.AcceptedInputFileTypes.FASTQGZ.toString()) || f.getName().endsWith(Enums.AcceptedInputFileTypes.FASTQ.toString())) {
            this.ir = new FastqReader();
        } else if (f.getName().endsWith(Enums.AcceptedInputFileTypes.FAGZ.toString()) || f.getName().endsWith(Enums.AcceptedInputFileTypes.FA.toString()) || f.getName().endsWith(Enums.AcceptedInputFileTypes.FASTAGZ.toString()) || f.getName().endsWith(Enums.AcceptedInputFileTypes.FASTA.toString())) {
            this.ir = new FastaReader();
        } else {
            String message = "Wrong input file type" + Utilities.ls + "Accepted file types are:";
            for (Enums.AcceptedInputFileTypes a : Enums.AcceptedInputFileTypes.values()) {
                message = message + " " + a.toString();
            }
            throw new Exception(message + Utilities.ls);
        }
        this.ir.openFile(f);
    }

    public void closeReader() {
        try {
            this.ir.closeReader();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ReadRecord readNextRecord() {
        ReadRecord rr = this.ir.readNextRecord();
        if (rr != null) {
            ++this.readrecordnumber;
        }
        return rr;
    }
}

