/*
 * Decompiled with CFR 0.152.
 */
package org.fda.inputdataparser;

import java.io.File;
import java.util.regex.Matcher;
import org.fda.inputdataparser.FastqRecord;
import org.fda.inputdataparser.ReadRecord;
import org.fda.inputdataparser.Reader;

public class FastqReader
extends Reader {
    @Override
    public ReadRecord readNextRecord() {
        String header = null;
        FastqRecord dr = null;
        String qStr = null;
        String read = null;
        int gc_count = 0;
        int i = 0;
        int rem = 0;
        try {
            String line;
            while ((line = this.br.readLine()) != null) {
                line = line.trim();
                rem = i % 4;
                switch (rem) {
                    case 0: {
                        header = line;
                        break;
                    }
                    case 1: {
                        read = line;
                        Matcher matcher = this.gc_pattern.matcher(read);
                        while (matcher.find()) {
                            ++gc_count;
                        }
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        qStr = line;
                    }
                }
                if (++i != 4) continue;
            }
            if (line != null) {
                dr = new FastqRecord(header, read, qStr, gc_count);
                ++this.readrecordnumber;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dr;
    }

    public static void main(String[] args) {
        File f = new File("2A1_CGATGT_L001_R2_002.fastq");
        FastqReader r = new FastqReader();
        try {
            ReadRecord fr;
            r.openFile(f);
            while ((fr = ((Reader)r).readNextRecord()) != null) {
            }
            r.closeReader();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

