/*
 * Decompiled with CFR 0.152.
 */
package org.fda.inputdataparser;

import java.io.File;
import java.security.MessageDigest;
import java.util.List;
import org.fda.data.Utilities;
import org.fda.inputdataparser.FastaRecord;
import org.fda.inputdataparser.ReadRecord;
import org.fda.inputdataparser.Reader;
import org.fda.intervaltree.Interval;

public class FastaReader
extends Reader {
    @Override
    public ReadRecord readNextRecord() {
        String header = null;
        FastaRecord dr = null;
        StringBuilder sb = new StringBuilder();
        boolean seqRead = false;
        try {
            String line;
            MessageDigest digest = MessageDigest.getInstance(Utilities.hashalg.toString());
            MessageDigest digest2 = MessageDigest.getInstance(Utilities.hashalg.toString());
            while ((line = this.br.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                if (line.startsWith(">")) {
                    if (!seqRead) {
                        header = line;
                        digest.update(header.getBytes("UTF-8"));
                        continue;
                    }
                    this.br.reset();
                    break;
                }
                seqRead = true;
                sb = sb.append(line);
                digest.update(line.getBytes("UTF-8"));
                digest2.update(line.getBytes("UTF-8"));
                this.br.mark(50000);
            }
            if (seqRead) {
                dr = new FastaRecord(header, sb.toString(), digest.digest(), digest2.digest());
                ++this.readrecordnumber;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dr;
    }

    public static void main(String[] args) {
        File f = new File("contigs.fa");
        FastaReader r = new FastaReader();
        try {
            ReadRecord fr;
            r.openFile(f);
            while ((fr = r.readNextRecord()) != null) {
                if (((FastaRecord)fr).getName().equalsIgnoreCase("contig508")) {
                    List<Interval> ivt = ((FastaRecord)fr).getnIntervalsTree().inOrder();
                    for (Interval i : ivt) {
                        System.out.println(i.getlow() + "\t" + i.gethigh());
                    }
                }
                System.out.println(((FastaRecord)fr).getName() + "\t" + ((FastaRecord)fr).getNcount());
            }
            r.closeReader();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

