/*
 * Decompiled with CFR 0.152.
 */
package org.fda.inputdataparser;

import java.io.File;
import java.io.IOException;
import org.fda.data.Utilities;
import org.fda.inputdataparser.FastaReader;
import org.fda.inputdataparser.FastaRecord;
import org.fda.inputdataparser.FastaWriter;

public class FastaFilter {
    private File infile;
    private File outfile;

    public FastaFilter(File infile, File outfile) {
        this.infile = infile;
        if (outfile != null) {
            this.outfile = outfile;
        } else {
            String[] n = infile.getName().split("\\.");
            this.outfile = new File("filtered_" + n[0] + ".fa");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter() {
        FastaReader fr = new FastaReader();
        FastaWriter frw = new FastaWriter(this.outfile);
        try {
            FastaRecord r;
            fr.openFile(this.infile);
            while ((r = (FastaRecord)fr.readNextRecord()) != null) {
                if (r.getReadRecordLength() < Utilities.fastarecordlengththreshold) continue;
                frw.write(r);
            }
            fr.closeReader();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        finally {
            frw.closeWriter();
        }
    }
}

