/*
 * Decompiled with CFR 0.152.
 */
package org.fda.inputdataparser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.fda.inputdataparser.FastaReader;
import org.fda.inputdataparser.FastaWriter;
import org.fda.inputdataparser.ReadRecord;

public class ChromosomePicker {
    private final File in;
    private final File out;
    private final Set<String> amap = new HashSet<String>();

    public ChromosomePicker(File in, File out, File chrfile) {
        this.in = in;
        this.out = out;
        try (BufferedReader br = new BufferedReader(new FileReader(chrfile));){
            String line;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                this.amap.add(line);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void pickChrs() {
        try {
            ReadRecord f_rec;
            FastaReader fr = new FastaReader();
            fr.openFile(this.in);
            FastaWriter frw = new FastaWriter(this.out);
            while ((f_rec = fr.readNextRecord()) != null) {
                if (!this.amap.contains(f_rec.getName())) continue;
                frw.write(f_rec);
            }
            fr.closeReader();
            frw.closeWriter();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

