/*
 * Decompiled with CFR 0.152.
 */
package org.fda.graphdrawing.data;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.fda.data.Utilities;
import org.fda.graphdrawing.data.CategoryLineChartDatasetSeries;

public class CategoryLineChartDataset {
    private final List<CategoryLineChartDatasetSeries> data = new ArrayList<CategoryLineChartDatasetSeries>();
    private final List<String> colnames = new ArrayList<String>();

    public List<CategoryLineChartDatasetSeries> getData() {
        return this.data;
    }

    public List<String> getSeriesnames() {
        return this.colnames;
    }

    public void addSeries(CategoryLineChartDatasetSeries s) {
        this.data.add(s);
        this.colnames.add(s.getSerieName());
    }

    public String toTable() {
        int i;
        NumberFormat nr = Utilities.numberFormatter;
        List<String> rownames = this.data.get(0).getXlist();
        StringBuilder sb = new StringBuilder();
        sb.append(" \t");
        for (i = 0; i < this.colnames.size(); ++i) {
            sb.append(this.colnames.get(i)).append("\t");
        }
        sb.append(Utilities.ls);
        for (i = 0; i < rownames.size(); ++i) {
            sb.append(rownames.get(i)).append("\t");
            for (int j = 0; j < this.colnames.size(); ++j) {
                if (this.data.get(j).getYlist().get(i) < 0.0 || Double.compare(this.data.get(j).getYlist().get(i), Double.NaN) == 0) {
                    sb.append("-\t");
                    continue;
                }
                sb.append(nr.format(this.data.get(j).getYlist().get(i))).append("\t");
            }
            sb.append(Utilities.ls);
        }
        sb.append(Utilities.ls);
        return sb.toString();
    }
}

