/*
 * Decompiled with CFR 0.152.
 */
package org.fda.evaluator;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.fda.alignment.ScaffoldContig;
import org.fda.data.ReferenceSet;
import org.fda.data.Utilities;
import org.fda.evaluator.EvaluatorBase;
import org.fda.evaluator.Processor;
import org.fda.evaluator.QLPair;

public class Reevaluator
extends EvaluatorBase {
    public Reevaluator(File sourceFolder, File outdir, ReferenceSet chrset, File modfile) throws IOException {
        super(sourceFolder, outdir, chrset);
        File tmpContigFile = new File(sourceFolder.getAbsolutePath() + File.separator + Utilities.contigBinFileName);
        if (this.outdir == null) {
            this.outdir = sourceFolder;
            this.writeToDest = false;
        } else {
            this.outdir.mkdirs();
            for (String d : Utilities.sub_dirs) {
                File tmpdir = new File(this.outdir.getAbsolutePath() + File.separator + d);
                tmpdir.mkdirs();
            }
            if (new File(this.sourceFolder + File.separator + Utilities.assemblystatsFile).exists()) {
                Files.copy(new File(this.sourceFolder + File.separator + Utilities.assemblystatsFile).toPath(), new File(this.outdir + File.separator + Utilities.assemblystatsFile).toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            if (new File(this.sourceFolder + File.separator + Utilities.chrGapsFileName).exists()) {
                Files.copy(new File(this.sourceFolder + File.separator + Utilities.chrGapsFileName).toPath(), new File(this.outdir + File.separator + Utilities.chrGapsFileName).toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        Files.copy(modfile.toPath(), new File(this.outdir + File.separator + Utilities.modelFileName).toPath(), StandardCopyOption.REPLACE_EXISTING);
        this.contigfile = tmpContigFile;
        this.outfile = new File(this.outdir.getAbsolutePath() + File.separator + Utilities.contigsStats);
        this.alignmentfile = new File(this.outdir.getAbsolutePath() + File.separator + Utilities.alignmentFile);
        this.missassemblyFile = new File(outdir.getAbsolutePath() + File.separator + Utilities.misassemblyFile);
        this.p = new Processor(this, chrset, outdir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QLPair[] process() {
        ObjectOutputStream outstream = null;
        ObjectInputStream instream = null;
        QLPair[] quallist = null;
        try {
            File tmpfile;
            if (this.sourceFolder.equals(this.outdir)) {
                tmpfile = new File(this.contigfile.getAbsolutePath() + ".tmp");
                tmpfile.deleteOnExit();
                Files.move(this.contigfile.toPath(), tmpfile.toPath(), StandardCopyOption.ATOMIC_MOVE);
            } else {
                tmpfile = this.contigfile;
                this.contigfile = new File(this.outdir.getAbsolutePath() + File.separator + Utilities.contigBinFileName);
                Files.copy(new File(this.sourceFolder.getAbsolutePath() + File.separator + Utilities.chrStatFileName).toPath(), new File(this.outdir.getAbsolutePath() + File.separator + Utilities.chrStatFileName).toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            outstream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.contigfile)));
            instream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(tmpfile)));
            int contigNumber = instream.readInt();
            outstream.writeInt(contigNumber);
            quallist = new QLPair[contigNumber];
            int indx = 0;
            while (true) {
                ScaffoldContig als = (ScaffoldContig)instream.readObject();
                als.assignQuality();
                this.p.process(als);
                outstream.writeObject(als);
                this.bw.append(als.toString(false));
                this.bwc.append(als.toString(true));
                if (als.getIsMisassembled() || als.containsScaffoldingGap()) {
                    this.misassemblyBw.append(als.getString4Misassemblies());
                }
                quallist[indx] = new QLPair(als.getContigLength(), als.getQuality());
                ++indx;
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            try {
                outstream.close();
                instream.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        catch (IOException ex) {
            try {
                if (!(ex instanceof EOFException)) {
                    ex.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    outstream.close();
                    instream.close();
                }
                catch (IOException ex2) {
                    ex2.printStackTrace();
                }
            }
        }
        return quallist;
    }
}

