/*
 * Decompiled with CFR 0.152.
 */
package org.fda.evaluator;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fda.alignment.Alignment;
import org.fda.alignment.ScaffoldContig;
import org.fda.data.QUAL;
import org.fda.data.Reference;
import org.fda.data.ReferenceSet;
import org.fda.evaluator.EvaluatorBase;
import org.fda.intervaltree.Interval;
import org.fda.intervaltree.IntervalSearchTree;
import org.fda.intervaltree.MergedIntervalSearchTree;

public class IntervalMerger {
    private final Map<Reference, IntervalSearchTree> mergedIntervalTreeMap;
    private final Map<Reference, Long> totalRealSizeOfAlignedContigsByChr;
    private long totCoveredLen = 0L;
    private long totalCoveredReferenceSizeSoFar = 0L;
    long totalGenomeLength = 0L;
    private double totalCovRatio;
    private long totAlignedLengthOnContigs = 0L;
    private QUAL quallevel;
    private double duplicationRatio;
    private double validityRatio;
    private long totContigLength = 0L;
    private final EvaluatorBase ev;
    private final ReferenceSet refset;

    public double getDuplicationRatio() {
        return this.duplicationRatio;
    }

    public double getInvDupRatio() {
        if (this.duplicationRatio == 0.0) {
            return 0.0;
        }
        return 1.0 / this.duplicationRatio;
    }

    public double getTotCovRatio() {
        return this.totalCovRatio;
    }

    public IntervalMerger(ReferenceSet cset, QUAL qual, EvaluatorBase ev) throws FileNotFoundException, IOException {
        this.refset = cset;
        this.ev = ev;
        this.quallevel = qual;
        this.mergedIntervalTreeMap = new HashMap<Reference, IntervalSearchTree>();
        this.totalRealSizeOfAlignedContigsByChr = new HashMap<Reference, Long>();
        for (Reference c : this.refset.getRefs()) {
            this.mergedIntervalTreeMap.put(c, new MergedIntervalSearchTree());
            this.totalRealSizeOfAlignedContigsByChr.put(c, 0L);
            this.totalGenomeLength += c.getLength();
        }
    }

    public ReferenceSet getChrSet() {
        return this.refset;
    }

    public Map<Reference, IntervalSearchTree> getMergedIntervalTreeMap() {
        return this.mergedIntervalTreeMap;
    }

    public Map<Reference, List<Interval>> getIntervalListsFromChrTrees(Map<Reference, IntervalSearchTree> treeMap) {
        HashMap<Reference, List<Interval>> map = new HashMap<Reference, List<Interval>>();
        for (Reference c : this.refset.getRefs()) {
            IntervalSearchTree chrTree = treeMap.get(c);
            List<Interval> intList = chrTree.inOrder();
            map.put(c, intList);
        }
        return map;
    }

    public void process(ScaffoldContig ent, boolean generateSubs) throws IOException {
        for (Alignment a : ent.getAlignments()) {
            IntervalSearchTree chrTree = this.mergedIntervalTreeMap.get(a.getReference());
            this.totalCoveredReferenceSizeSoFar -= ((MergedIntervalSearchTree)chrTree).getTotalSize();
            ((MergedIntervalSearchTree)chrTree).put(a.getReferenceInterval(), generateSubs);
            this.totalCoveredReferenceSizeSoFar += ((MergedIntervalSearchTree)chrTree).getTotalSize();
            this.totalRealSizeOfAlignedContigsByChr.put(a.getReference(), this.totalRealSizeOfAlignedContigsByChr.get(a.getReference()) + (long)a.getRefAlignmentLength());
            this.totAlignedLengthOnContigs += (long)a.getContigAlignmentLength();
        }
        this.totContigLength += (long)ent.getContigLength();
    }

    public void finalize_process(long totContSizeWOgaps) {
        this.totalCovRatio = Math.min(1.0, (double)this.totalCoveredReferenceSizeSoFar / (double)(this.refset.getGenomesize() - this.refset.getGapsize()));
        this.duplicationRatio = this.totalCoveredReferenceSizeSoFar != 0L ? Math.max(1.0, (double)this.totAlignedLengthOnContigs / (double)this.totalCoveredReferenceSizeSoFar) : 0.0;
        this.validityRatio = this.totContigLength != 0L ? Math.min((double)this.totAlignedLengthOnContigs / (double)totContSizeWOgaps, 1.0) : 0.0;
    }

    public double getValidityRatio() {
        return this.validityRatio;
    }

    public QUAL getQuallevel() {
        return this.quallevel;
    }

    public void setQuallevel(QUAL quallevel) {
        this.quallevel = quallevel;
    }
}

