/*
 * Decompiled with CFR 0.152.
 */
package org.fda.evaluator;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ArrayBlockingQueue;
import org.fda.alignment.AlignmentFilterG;
import org.fda.alignment.AlignmentFilterQ;
import org.fda.alignment.ScaffoldContig;
import org.fda.alignmentparser.AlignmentReaderRunnable;
import org.fda.alignmentparser.delta.DeltaReaderRunnable;
import org.fda.alignmentparser.paf.PafReaderRunnable;
import org.fda.data.Enums;
import org.fda.data.Reference;
import org.fda.data.ReferenceSet;
import org.fda.data.Utilities;
import org.fda.multithreading.StandardQMonitor;
import org.fda.regression.DataValue;
import org.fda.regression.RegressionModel;
import org.fda.regression.RegressionModule;

public class Evaluator4Artifact {
    private final List<File> alignmentFileArr = new ArrayList<File>();
    private final ReferenceSet chrset;
    private File modelfile;
    private RegressionModel rm;
    private final Map<Reference, List<DataValue>> ramap;
    private final Map<String, String> contigid2ref;
    private final File sourceFolder;

    public File getModelfile() {
        return this.modelfile;
    }

    public RegressionModel getRm() {
        return this.rm;
    }

    public Evaluator4Artifact(File sourceFolder, File outfolder, ReferenceSet chrset, Map<String, List<String>> refmap) {
        this.sourceFolder = sourceFolder;
        this.contigid2ref = new HashMap<String, String>();
        if (refmap != null) {
            for (String ref : refmap.keySet()) {
                for (String contigid : refmap.get(ref)) {
                    this.contigid2ref.put(contigid, ref);
                }
            }
        } else {
            for (Reference re : chrset.getRefs()) {
                this.contigid2ref.put(re.getRefID(), re.getRefID());
            }
        }
        Utilities.findAllFiles(sourceFolder, this.alignmentFileArr, new String[]{Utilities.alignmentTool.getFileExtension()}, new String[0]);
        this.chrset = chrset;
        this.modelfile = new File(outfolder.getAbsolutePath() + File.separator + Utilities.modelFileName);
        this.ramap = new TreeMap<Reference, List<DataValue>>();
        for (Reference r : chrset.getRefs()) {
            this.ramap.put(r, new ArrayList());
        }
    }

    public Evaluator4Artifact(File sourceFolder, File outfolder, ReferenceSet chrset, Map<String, List<String>> refmap, File modelFile) {
        this(sourceFolder, outfolder, chrset, refmap);
        this.modelfile = modelFile;
    }

    private Map<File, List<File>> returnPartitions() {
        HashMap<File, List<File>> fmap = new HashMap<File, List<File>>();
        for (File f : this.alignmentFileArr) {
            File parent = f.getParentFile();
            if (fmap.containsKey(parent)) {
                ((List)fmap.get(parent)).add(f);
                continue;
            }
            ArrayList<File> tmp = new ArrayList<File>();
            tmp.add(f);
            fmap.put(parent, tmp);
        }
        return fmap;
    }

    public void process() {
        List<DataValue> alldata;
        DataValue dv;
        List<ScaffoldContig> als = this.initialProcessing();
        for (ScaffoldContig scaffoldContig : als) {
            dv = new DataValue(scaffoldContig.getId(), scaffoldContig.getContigLength(), Utilities.initialAlignmentDistanceThreshold, scaffoldContig.getTotalInconsistencyNumber());
            alldata = this.ramap.get(this.chrset.findReference(this.contigid2ref.get(scaffoldContig.getId())));
            alldata.add(dv);
        }
        for (int k = Utilities.initialAlignmentDistanceThreshold + Utilities.alignmentDistanceThresholdInc; k <= Utilities.maxAlignmentDistanceThreshold; k += Utilities.alignmentDistanceThresholdInc) {
            Utilities.alignmentDistanceThreshold = k;
            this.iterativeProcessing(als);
            for (ScaffoldContig s : als) {
                dv = new DataValue(s.getId(), s.getContigLength(), k, s.getTotalInconsistencyNumber());
                alldata = this.ramap.get(this.chrset.findReference(this.contigid2ref.get(s.getId())));
                alldata.add(dv);
            }
        }
        this.rm = RegressionModule.process(this.ramap, this.chrset);
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.modelfile)));){
            objectOutputStream.writeObject(this.rm);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private List<ScaffoldContig> initialProcessing() {
        Utilities.alignmentDistanceThreshold = Utilities.initialAlignmentDistanceThreshold;
        StandardQMonitor qm = null;
        Map<File, List<File>> fmap = this.returnPartitions();
        try {
            int i;
            ArrayBlockingQueue<Object> filesListQueue = new ArrayBlockingQueue<Object>(fmap.size() + Utilities.no_ReaderThreads);
            filesListQueue.addAll(fmap.values());
            for (i = 0; i < Utilities.no_ReaderThreads; ++i) {
                filesListQueue.put((Object)Enums.STOPOBJECT.STOP);
            }
            ArrayBlockingQueue<Enums.STOPOBJECT> alignmentSetQueue = new ArrayBlockingQueue<Enums.STOPOBJECT>(Utilities.alignmentqueuesize);
            ArrayBlockingQueue<Enums.STOPOBJECT> filteredQueue = new ArrayBlockingQueue<Enums.STOPOBJECT>(Utilities.alignmentqueuesize);
            Thread[] deltareaderArr = new Thread[Utilities.no_ReaderThreads];
            for (i = 0; i < deltareaderArr.length; ++i) {
                AlignmentReaderRunnable rmb = Utilities.alignmentTool == Enums.AlignmentTool.nucmer ? new DeltaReaderRunnable(filesListQueue, alignmentSetQueue, this.chrset, i, this.sourceFolder) : new PafReaderRunnable(filesListQueue, alignmentSetQueue, this.chrset, i, this.sourceFolder);
                deltareaderArr[i] = new Thread(rmb);
                deltareaderArr[i].start();
            }
            Thread[] filterArr = new Thread[Utilities.no_filterThreads];
            for (i = 0; i < filterArr.length; ++i) {
                filterArr[i] = Utilities.globalFilter ? new Thread(new AlignmentFilterG(alignmentSetQueue, i, filteredQueue)) : new Thread(new AlignmentFilterQ(alignmentSetQueue, i, filteredQueue));
                filterArr[i].start();
            }
            qm = new StandardQMonitor(filteredQueue);
            Thread qmt = new Thread(qm);
            qmt.start();
            for (i = 0; i < deltareaderArr.length; ++i) {
                deltareaderArr[i].join();
            }
            for (i = 0; i < filterArr.length; ++i) {
                alignmentSetQueue.put(Enums.STOPOBJECT.STOP);
            }
            for (i = 0; i < filterArr.length; ++i) {
                filterArr[i].join();
            }
            filteredQueue.put(Enums.STOPOBJECT.STOP);
            qmt.join();
        }
        catch (InterruptedException io) {
            io.printStackTrace();
        }
        return qm.getContigs();
    }

    private void iterativeProcessing(List<ScaffoldContig> als) {
        for (ScaffoldContig al : als) {
            al.setMisassembly();
        }
    }
}

