/*
 * Decompiled with CFR 0.152.
 */
package org.fda.evaluator;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import org.fda.alignment.AlignmentFilterG;
import org.fda.alignment.AlignmentFilterQ;
import org.fda.alignment.ScaffoldContig;
import org.fda.alignmentparser.AlignmentReaderRunnable;
import org.fda.alignmentparser.delta.DeltaReaderRunnable;
import org.fda.alignmentparser.paf.PafReaderRunnable;
import org.fda.data.Enums;
import org.fda.data.ReferenceSet;
import org.fda.data.Utilities;
import org.fda.evaluator.EvaluatorBase;
import org.fda.evaluator.Processor;
import org.fda.evaluator.QLPair;
import org.fda.multithreading.StandaloneContigAlignmentQueueMonitor;

public class Evaluator
extends EvaluatorBase {
    private List<File> alignmentFileArr = new ArrayList<File>();

    public Evaluator(File sourceFolder, File outdir, ReferenceSet chrset) throws IOException {
        super(sourceFolder, outdir, chrset);
        Utilities.findAllFiles(sourceFolder, this.alignmentFileArr, new String[]{Utilities.alignmentTool.getFileExtension()}, new String[0]);
        this.contigfile = new File(outdir.getAbsolutePath() + File.separator + Utilities.contigBinFileName);
        this.outfile = new File(outdir.getAbsolutePath() + File.separator + Utilities.contigsStats);
        this.alignmentfile = new File(outdir.getAbsolutePath() + File.separator + Utilities.alignmentFile);
        this.missassemblyFile = new File(outdir.getAbsolutePath() + File.separator + Utilities.misassemblyFile);
        this.p = new Processor(this, chrset, outdir);
    }

    private Map<File, List<File>> returnPartitions() {
        HashMap<File, List<File>> fmap = new HashMap<File, List<File>>();
        for (File f : this.alignmentFileArr) {
            File parent = f.getParentFile();
            if (fmap.containsKey(parent)) {
                ((List)fmap.get(parent)).add(f);
                continue;
            }
            ArrayList<File> tmp = new ArrayList<File>();
            tmp.add(f);
            fmap.put(parent, tmp);
        }
        return fmap;
    }

    @Override
    public QLPair[] process() {
        StandaloneContigAlignmentQueueMonitor qm = null;
        Map<File, List<File>> fmap = this.returnPartitions();
        try {
            int i;
            ArrayBlockingQueue<Object> filesListQueue = new ArrayBlockingQueue<Object>(fmap.size() + Utilities.no_ReaderThreads);
            filesListQueue.addAll(fmap.values());
            for (i = 0; i < Utilities.no_ReaderThreads; ++i) {
                filesListQueue.put((Object)Enums.STOPOBJECT.STOP);
            }
            ArrayBlockingQueue<Enums.STOPOBJECT> alignmentSetQueue = new ArrayBlockingQueue<Enums.STOPOBJECT>(Utilities.alignmentqueuesize);
            ArrayBlockingQueue<Enums.STOPOBJECT> filteredQueue = new ArrayBlockingQueue<Enums.STOPOBJECT>(Utilities.alignmentqueuesize);
            Thread[] alignmentreaderArr = new Thread[Utilities.no_ReaderThreads];
            for (i = 0; i < alignmentreaderArr.length; ++i) {
                AlignmentReaderRunnable rmb = Utilities.alignmentTool == Enums.AlignmentTool.nucmer ? new DeltaReaderRunnable(filesListQueue, alignmentSetQueue, this.chrset, i, this.sourceFolder) : new PafReaderRunnable(filesListQueue, alignmentSetQueue, this.chrset, i, this.sourceFolder);
                alignmentreaderArr[i] = new Thread(rmb);
                alignmentreaderArr[i].start();
            }
            Thread[] filterArr = new Thread[Utilities.no_filterThreads];
            for (i = 0; i < filterArr.length; ++i) {
                filterArr[i] = Utilities.globalFilter ? new Thread(new AlignmentFilterG(alignmentSetQueue, i, filteredQueue)) : new Thread(new AlignmentFilterQ(alignmentSetQueue, i, filteredQueue));
                filterArr[i].start();
            }
            qm = new StandaloneContigAlignmentQueueMonitor(filteredQueue, this.contigfile, this.bw, this.sourceFolder, this.bwc, this.p);
            Thread qmt = new Thread(qm);
            qmt.start();
            for (i = 0; i < alignmentreaderArr.length; ++i) {
                alignmentreaderArr[i].join();
            }
            for (i = 0; i < filterArr.length; ++i) {
                alignmentSetQueue.put(Enums.STOPOBJECT.STOP);
            }
            for (i = 0; i < filterArr.length; ++i) {
                filterArr[i].join();
            }
            filteredQueue.put(Enums.STOPOBJECT.STOP);
            qmt.join();
        }
        catch (InterruptedException io) {
            io.printStackTrace();
        }
        QLPair[] histData = this.getHistData(qm.getContigCount());
        return histData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QLPair[] getHistData(int contigNumber) {
        QLPair[] quallist = new QLPair[contigNumber];
        ObjectOutputStream outstream = null;
        ObjectInputStream instream = null;
        try {
            File tmpfile = new File(this.contigfile.getAbsolutePath() + ".tmp");
            tmpfile.deleteOnExit();
            Files.move(this.contigfile.toPath(), tmpfile.toPath(), StandardCopyOption.ATOMIC_MOVE);
            outstream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.contigfile)));
            outstream.writeInt(contigNumber);
            instream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(tmpfile)));
            int indx = 0;
            while (true) {
                ScaffoldContig als;
                if ((als = (ScaffoldContig)instream.readObject()).getIsMisassembled() || als.containsScaffoldingGap()) {
                    this.misassemblyBw.append(als.getString4Misassemblies());
                }
                outstream.writeObject(als);
                quallist[indx] = new QLPair(als.getContigLength(), als.getQuality());
                ++indx;
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            try {
                outstream.close();
                instream.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        catch (IOException ex) {
            try {
                if (!(ex instanceof EOFException)) {
                    ex.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    outstream.close();
                    instream.close();
                }
                catch (IOException ex2) {
                    ex2.printStackTrace();
                }
            }
        }
        return quallist;
    }
}

