/*
 * Decompiled with CFR 0.152.
 */
package org.fda.dataaligner;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.List;
import org.fda.basicstats.BasicStatsCompute;
import org.fda.data.ReferenceFile;
import org.fda.data.ReferenceSet;
import org.fda.data.Utilities;
import org.fda.inputdataparser.FastaWriter;
import org.fda.inputdataparser.InputReader;
import org.fda.inputdataparser.ReadRecord;
import org.fda.multithreading.ScriptHelper;

public class DataPartitioner {
    private final File inputFile;
    private int numberofsubfolders;
    private final File targetFolder;
    private final File alignerDir;
    private final ReferenceSet chrset;
    private final BasicStatsCompute bsc;
    private final List<File> touchFiles;
    private ScriptHelper shelper;

    public List<File> getTouchFiles() {
        return this.touchFiles;
    }

    public DataPartitioner(File inputFile, int numberofsubfolders, File targetFolder, File alignerDir, ReferenceSet cset, BasicStatsCompute bsc) {
        this.inputFile = inputFile;
        this.numberofsubfolders = numberofsubfolders;
        this.targetFolder = targetFolder;
        this.chrset = cset;
        this.alignerDir = alignerDir;
        this.bsc = bsc;
        this.touchFiles = new ArrayList<File>();
    }

    public boolean divideDataAndCreateScripts() {
        int reffilenum = this.chrset.getReferenceFiles().size();
        File[] tmpFolders = new File[this.numberofsubfolders];
        File[] tmpScripts = new File[this.numberofsubfolders * reffilenum];
        BufferedWriter[] bwScriptArr = new BufferedWriter[this.numberofsubfolders * reffilenum];
        FastaWriter[] fw = new FastaWriter[this.numberofsubfolders];
        InputReader ir = new InputReader();
        try {
            long actualNumberOfSubfolders;
            ReadRecord f_rec;
            int it_index;
            for (int i = 0; i < this.numberofsubfolders; ++i) {
                String s = Utilities.giveName(i);
                tmpFolders[i] = new File(this.targetFolder.getAbsolutePath() + File.separator + "datapart" + s);
                tmpFolders[i].mkdirs();
                if (this.numberofsubfolders > 1) {
                    fw[i] = new FastaWriter(tmpFolders[i].getAbsolutePath() + File.separator + "datapart" + s + ".fa");
                }
                for (int j = 0; j < reffilenum; ++j) {
                    it_index = i * reffilenum + j;
                    String t = Utilities.giveName(j);
                    String filename = reffilenum != 1 ? "datapart" + s + "_to_refpart" + t : "datapart" + s + "_to_" + Utilities.getPrefix(this.chrset.getReferenceFiles().get(0).getFile());
                    tmpScripts[it_index] = new File(tmpFolders[i].getAbsolutePath() + File.separator + "s_" + filename + ".sh");
                    bwScriptArr[it_index] = new BufferedWriter(new FileWriter(tmpScripts[it_index]));
                }
            }
            int index = 0;
            int direction = 1;
            ir.openFile(this.inputFile);
            while ((f_rec = ir.readNextRecord()) != null) {
                this.bsc.addLength(f_rec);
                if (this.numberofsubfolders <= 1) continue;
                if (index < this.numberofsubfolders && index >= 0) {
                    fw[index].write(f_rec);
                    index += direction;
                    continue;
                }
                fw[index += (direction *= -1)].write(f_rec);
                index += direction;
            }
            ir.closeReader();
            if (this.numberofsubfolders > 1) {
                for (int g = 0; g < fw.length; ++g) {
                    fw[g].closeWriter();
                }
            }
            if ((actualNumberOfSubfolders = ir.getReadRecordNumber()) < (long)this.numberofsubfolders) {
                int j;
                int i;
                for (i = (int)actualNumberOfSubfolders; i < this.numberofsubfolders; ++i) {
                    for (j = 0; j < reffilenum; ++j) {
                        it_index = i * reffilenum + j;
                        bwScriptArr[it_index].close();
                    }
                    Utilities.deleteFolder(tmpFolders[i]);
                }
                this.numberofsubfolders = (int)actualNumberOfSubfolders;
                File[] tmpScriptArr = new File[this.numberofsubfolders * reffilenum];
                for (i = 0; i < this.numberofsubfolders; ++i) {
                    for (j = 0; j < reffilenum; ++j) {
                        it_index = i * reffilenum + j;
                        tmpScriptArr[it_index] = tmpScripts[it_index];
                    }
                }
                tmpScripts = tmpScriptArr;
            }
            for (int i = 0; i < this.numberofsubfolders; ++i) {
                for (int j = 0; j < reffilenum; ++j) {
                    String outputname;
                    it_index = i * reffilenum + j;
                    bwScriptArr[it_index].append("#!/bin/bash" + Utilities.ls + "#$ -e " + tmpFolders[i].getAbsolutePath() + Utilities.ls + "#$ -o " + tmpFolders[i].getAbsolutePath() + Utilities.ls + "#$ -S /bin/bash" + Utilities.ls);
                    bwScriptArr[it_index].append("hostname" + Utilities.ls);
                    bwScriptArr[it_index].append("cd " + tmpFolders[i].getAbsolutePath() + Utilities.ls);
                    ReferenceFile c = this.chrset.getReferenceFiles().get(j);
                    String chr = Utilities.getPrefix(c.getFile());
                    if (this.numberofsubfolders == 1) {
                        outputname = Utilities.getPrefix(this.inputFile) + "_to_" + chr;
                        switch (Utilities.alignmentTool) {
                            case nucmer: {
                                bwScriptArr[it_index].append(this.alignerDir.getAbsolutePath() + File.separator + "nucmer --mum -p " + outputname + " " + c.getAbsolutePath() + " " + this.inputFile.getAbsolutePath() + Utilities.ls);
                                break;
                            }
                            case minimap2: {
                                bwScriptArr[it_index].append(this.alignerDir.getAbsolutePath() + File.separator + "minimap2 -c -x asm5 --mask-level 0.9 --min-occ 200 -g 2500 --score-N 2 " + c.getAbsolutePath() + " " + this.inputFile.getAbsolutePath() + " -t " + Utilities.no_threads + " > " + outputname + ".paf" + Utilities.ls);
                            }
                        }
                    } else {
                        outputname = Utilities.getPrefix(fw[i].getFile()) + "_to_" + chr;
                        switch (Utilities.alignmentTool) {
                            case nucmer: {
                                bwScriptArr[it_index].append(this.alignerDir.getAbsolutePath() + File.separator + "nucmer --mum -p " + outputname + " " + c.getAbsolutePath() + " " + fw[i].getFile().getAbsolutePath() + Utilities.ls);
                                break;
                            }
                            case minimap2: {
                                bwScriptArr[it_index].append(this.alignerDir.getAbsolutePath() + File.separator + "minimap2 -c -x asm5 --mask-level 0.9 --min-occ 200 -g 2500 --score-N 2 " + c.getAbsolutePath() + " " + fw[i].getFile().getAbsolutePath() + " -t " + Utilities.no_threads + " > " + outputname + ".paf" + Utilities.ls);
                            }
                        }
                    }
                    this.touchFiles.add(new File(tmpFolders[i].getAbsolutePath() + File.separator + outputname + ".touch"));
                    bwScriptArr[it_index].append("touch " + this.touchFiles.get(this.touchFiles.size() - 1).getAbsolutePath() + Utilities.ls);
                    bwScriptArr[it_index].close();
                }
            }
            this.shelper = new ScriptHelper(tmpScripts);
            this.shelper.run();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

