/*
 * Decompiled with CFR 0.152.
 */
package org.fda.dataaligner;

import java.io.File;
import java.util.List;
import org.fda.basicstats.BasicStatsCompute;
import org.fda.data.ReferenceSet;
import org.fda.dataaligner.DataPartitioner;

public class DataAligner {
    private final File inputFile;
    private final int numberofsubfolders;
    private final File targetFolder;
    private final File nucmerFolder;
    private final ReferenceSet chrset;
    private long totContigSize = 0L;
    private long noContigs = 0L;
    private int minCL;
    private int maxCL;
    private List<File> touchFiles;

    public List<File> getTouchFiles() {
        return this.touchFiles;
    }

    public DataAligner(File inputFile, int numberofsubfolders, File targetFolder, File nucmerFolder, ReferenceSet cset) {
        this.inputFile = inputFile;
        this.targetFolder = targetFolder;
        this.chrset = cset;
        this.nucmerFolder = nucmerFolder;
        this.numberofsubfolders = numberofsubfolders;
    }

    public int setAligners(boolean justModelling) {
        BasicStatsCompute bsc = new BasicStatsCompute(this.targetFolder, justModelling);
        int toRet = this.numberofsubfolders;
        DataPartitioner d = new DataPartitioner(this.inputFile, this.numberofsubfolders, this.targetFolder, this.nucmerFolder, this.chrset, bsc);
        if (!d.divideDataAndCreateScripts()) {
            return -1;
        }
        this.touchFiles = d.getTouchFiles();
        bsc.computeStats();
        this.totContigSize = bsc.getSum();
        this.noContigs = bsc.getNumberofContigs();
        this.minCL = bsc.getMin();
        this.maxCL = bsc.getMax();
        bsc.write2File();
        return toRet;
    }

    public long getNoContigs() {
        return this.noContigs;
    }

    public long getTotalContigSize() {
        return this.totContigSize;
    }

    public int getMaxContigLength() {
        return this.maxCL;
    }

    public int getMinContigLength() {
        return this.minCL;
    }
}

