/*
 * Decompiled with CFR 0.152.
 */
package org.fda.data;

import com.itextpdf.text.Document;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.fda.alignment.ScaffoldContig;
import org.fda.checks.CheckAligner;
import org.fda.commands.Command;
import org.fda.data.Enums;
import org.fda.data.QUALLEVEL;
import org.fda.data.Reference;
import org.fda.data.ReferenceSet;
import org.fda.graphdrawing.ImageFormat;
import org.fda.regression.RegressionModel;
import org.fda.regression.RegressionSubModel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;

public class Utilities {
    public static final Enums.HashingAlgorithm hashalg = Enums.HashingAlgorithm.SHA_256;
    public static final boolean IS_WINDOWS = System.getProperty("os.name").contains("indow");
    public static final int samplesize = 1000;
    public static final NumberFormat numberFormatter = NumberFormat.getInstance();
    public static final NumberFormat numberFormatterSmall = NumberFormat.getInstance();
    public static boolean contigsOverlap = false;
    public static double nratio = 0.5;
    public static double depthCoverage = 1.0;
    public static int simulation_mincontiglength = 50;
    public static double simulation_coverage_ratio_threshold = 0.05;
    public static final String assemblystatsFile = "reports" + File.separator + "assembly.stat";
    public static final String recordedDataFile = "partition.args";
    public static final String chrStatFileName = "bin" + File.separator + "references.bin";
    public static final String chrGapsFileName = "reports" + File.separator + "reference_scaffoldinggaps.report";
    public static final String contigsStats = "reports" + File.separator + "scaffolds.stat";
    public static final String alignmentFile = "reports" + File.separator + "scaffolds.alignment";
    public static final String misassemblyFile = "reports" + File.separator + "misassembly.report";
    public static final String contigObjFile = "contigRecords.bin";
    public static final String contigBinFileName = "bin" + File.separator + "scaffold_stats.bin";
    public static final String modelFileName = "bin" + File.separator + "model.bin";
    public static final String[] sub_dirs = new String[]{"bin", "charts", "reports"};
    public static final String cmd_key_word = "CMD";
    public static boolean showModelData = false;
    public static boolean showModelInTabularFormat = false;
    public static File rootDir;
    public static final long maxReferenceFileSize = 300000000L;
    public static final long maxQueryFileSize = 3000000000L;
    public static final String ls;
    private static final int maxDigitsInRefFileNumber = 5;
    public static Enums.ScriptRunMode submitJobs;
    public static String submitJobsParameters;
    public static boolean indeldiscovery;
    public static final int mark4BackTrack = 50000;
    public static final int intervalSize = 100000;
    public static Enums.AlignmentTool alignmentTool;
    public static ImageFormat format;
    public static boolean contigAlignmentDraw;
    public static Command current_cmd;
    public static boolean assignQuality;
    public static final double maxOverlap = 90.0;
    public static final double epsilon = -1.0;
    public static int alignmentIdentityThreshold;
    public static final int alignmentLengthThreshold = 0;
    public static int alignmentDistanceThreshold;
    public static int initialAlignmentDistanceThreshold;
    public static int alignmentDistanceThresholdInc;
    public static int maxAlignmentDistanceThreshold;
    public static double sizeratiodifference;
    public static double scaffoldinggapoverlapratio;
    public static RegressionModel regm;
    public static int fastarecordlengththreshold;
    public static double alpha;
    public static double beta;
    public static int lengthScalingFactor;
    public static double maxQScore;
    public static int sleepTime;
    public static int no_filterThreads;
    public static int no_threads;
    public static int no_ReaderThreads;
    public static final int queueingFactor = 10;
    public static int alignmentqueuesize;
    public static final int maxFileSize = 3000;
    public static final int mergeFactor = 4;
    public static final int mergerbuffsize = 100;
    public static boolean globalFilter;
    public static int minContigLength;
    public static int maxContigLength;
    public static Set<Integer> lengthLevels;
    public static int width;
    public static int height;
    public static int no_hist_bins;
    public static double intervalLength4Histogram;
    public static BigDecimal adder;
    public static double difference;
    public static QUALLEVEL qlevel;
    public static String version;

    public static int determineAllowedMinSimContigLength(long l) {
        if (l < 100000L) {
            return 50;
        }
        return 500;
    }

    public static String byteToHex(byte[] bytes) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            buff.append(Integer.toString((bytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return buff.toString();
    }

    public static String bytesToHex(byte[] in) {
        StringBuilder builder = new StringBuilder();
        for (byte b : in) {
            builder.append(String.format("%02x", b));
        }
        return builder.toString();
    }

    public static void checkAligner(File alignerDir) {
        CheckAligner mcheck = new CheckAligner(alignerDir);
        if (!mcheck.checkExecutables(alignmentTool.getExec())) {
            if (!new File(alignerDir.getAbsolutePath() + File.separator + "error.tch").exists()) {
                Runtime r = Runtime.getRuntime();
                try {
                    Process p = r.exec(alignmentTool.getCompileCommand(alignerDir));
                    int ret = p.waitFor();
                    if (ret != 0) {
                        File f = new File(alignerDir.getAbsolutePath() + File.separator + "error.tch");
                        if (!f.exists()) {
                            f.createNewFile();
                        }
                        System.out.println("ERROR: Alignment tool: " + (Object)((Object)alignmentTool) + " could not be compiled!");
                        System.exit(1);
                    }
                }
                catch (IOException | InterruptedException io) {
                    io.printStackTrace();
                }
            } else {
                System.out.println("ERROR: Alignment tool: " + (Object)((Object)alignmentTool) + " could not be compiled!");
                System.exit(1);
            }
        }
    }

    private static double getExpectedMisassembly(int contigSize, Reference r) {
        RegressionSubModel m = regm.getSubModel(r);
        return (double)contigSize * m.getLengthCoeff() + (double)alignmentDistanceThreshold * m.getThresholdCoeff() + m.getIntercept();
    }

    public static double getPenalty(int contigSize, int misNo, Reference r) {
        if (misNo == 0) {
            return 0.0;
        }
        double expected = Utilities.getExpectedMisassembly(contigSize, r);
        double realMiss = expected >= 0.0 ? (double)misNo - expected : (double)misNo;
        if (realMiss <= 1.0) {
            return 0.0;
        }
        return Math.log(realMiss) / Math.log(100.0);
    }

    public static double getLengthScalingCoefficient(int length) {
        double d = 1.0 / -Math.log10((double)length / ((double)lengthScalingFactor * 10.0));
        if (d < 0.0) {
            return 1.0;
        }
        return Math.min(d, 1.0);
    }

    public static List sample(int size) {
        Random r = new Random();
        double ratio = 1000.0 / (double)(size - 2);
        ArrayList<Integer> toret = new ArrayList<Integer>();
        toret.add(0);
        for (int i = 1; i < size - 1; ++i) {
            if (!(r.nextDouble() <= ratio)) continue;
            toret.add(i);
        }
        toret.add(size - 1);
        return toret;
    }

    public static String getRelativePath(File file) {
        int baselen = rootDir.getAbsolutePath().length();
        return file.getAbsolutePath().substring(baselen + 1);
    }

    public static String getRelativePath(File source, File file) {
        int baselen = source.getAbsolutePath().length();
        return file.getAbsolutePath().substring(baselen + 1);
    }

    public static void resetQSize() {
        alignmentqueuesize = Math.max(no_filterThreads * 10 / no_ReaderThreads, 10);
    }

    private static void setLengthLevels() {
        int st;
        for (int i = st = (int)Math.pow(10.0, (int)Math.log10(minContigLength)); i <= maxContigLength; i *= 10) {
            lengthLevels.add(i);
        }
    }

    public static void setLengthLevels(List<Integer> l) {
        lengthLevels = new TreeSet<Integer>();
        lengthLevels.addAll(l);
    }

    public static Set<Integer> getLengthLevels() {
        if (lengthLevels.isEmpty()) {
            Utilities.setLengthLevels();
        }
        return lengthLevels;
    }

    public static long scoreLocal(long scorej, int leni, int lenj, int olap, double idyi, double maxolap) {
        if (olap > 0 && ((double)olap / (double)leni * 100.0 > maxolap || (double)olap / (double)lenj * 100.0 > maxolap)) {
            return -1L;
        }
        return scorej + (long)((double)(leni - olap) * Math.pow(idyi, 2.0));
    }

    public static long scoreGlobal(long scorej, long leni, long olap, double idyi) {
        return scorej + (long)((double)(leni - olap) * Math.pow(idyi, 2.0));
    }

    public static long scoreGlobal2(long scorej, int leniR, int leniQ, int lenjR, int lenjQ, int olapR, int olapQ, double idyi, double maxolap) {
        if (olapR > 0 && ((double)olapR / (double)leniR * 100.0 > maxolap || (double)olapR / (double)lenjR * 100.0 > maxolap) || olapQ > 0 && ((double)olapQ / (double)leniQ * 100.0 > maxolap || (double)olapQ / (double)lenjQ * 100.0 > maxolap)) {
            return -1L;
        }
        int leni = leniR > leniQ ? leniQ : leniR;
        int olap = olapR > olapQ ? olapR : olapQ;
        return scorej + (long)((double)(leni - olap) * Math.pow(idyi, 2.0));
    }

    public static double calcPercentage(long a, long b) {
        if (b == 0L) {
            return 0.0;
        }
        return 100.0 * (double)a / (double)b;
    }

    public static double calcPercentage(double a, double b) {
        if (b == 0.0) {
            return 0.0;
        }
        return 100.0 * a / b;
    }

    public static boolean deleteFolder(File f) {
        File[] all = f.listFiles();
        boolean ret = true;
        for (File d : all) {
            if (d.isDirectory()) {
                ret &= Utilities.deleteFolder(d);
                continue;
            }
            ret &= d.delete();
        }
        if (ret) {
            boolean bl = f.delete();
        } else {
            System.out.println("Error deleting one of the subfolders/subfiles");
        }
        return ret;
    }

    public static void findAllFiles(File path, List<File> arr, String[] filetypes, String[] filestartsWith) {
        block15: {
            File[] files;
            block16: {
                for (String f : filetypes) {
                    f = f.trim();
                }
                for (String f : filestartsWith) {
                    f = f.trim();
                }
                boolean matched = false;
                if (!path.isFile()) break block16;
                if (filetypes.length > 0 && filestartsWith.length > 0) {
                    for (String f : filetypes) {
                        if (path.getName().endsWith(f)) {
                            for (String pref : filestartsWith) {
                                if (!path.getName().startsWith(pref)) continue;
                                arr.add(path);
                                matched = true;
                                break;
                            }
                        }
                        if (!matched) {
                            continue;
                        }
                        break block15;
                    }
                } else if (filetypes.length > 0 && filestartsWith.length == 0) {
                    for (String f : filetypes) {
                        if (!path.getName().endsWith(f)) continue;
                        arr.add(path);
                        break block15;
                    }
                } else if (filetypes.length == 0 && filestartsWith.length > 0) {
                    for (String f : filestartsWith) {
                        if (!path.getName().startsWith(f)) continue;
                        arr.add(path);
                        break block15;
                    }
                } else {
                    arr.add(path);
                }
                break block15;
            }
            if (!path.isDirectory()) break block15;
            for (File dirOrFile : files = path.listFiles()) {
                Utilities.findAllFiles(dirOrFile, arr, filetypes, filestartsWith);
            }
        }
    }

    public static Map<Enums.CoverageType, Integer> getEmptyCoverageMap() {
        HashMap<Enums.CoverageType, Integer> map = new HashMap<Enums.CoverageType, Integer>();
        for (Enums.CoverageType t : Enums.CoverageType.values()) {
            map.put(t, 0);
        }
        return map;
    }

    public static String giveName(int i) {
        String s = String.valueOf(i);
        int maxrep = 5 - s.length();
        if (maxrep < 0) {
            StringBuilder m = new StringBuilder();
            for (int z = 0; z < 5; ++z) {
                m.append("9");
            }
            System.out.println("The reference contains more than " + m.toString() + " scaffolds/contigs, which is the maximum allowed number of scaffolds/contigs in a reference");
            Utilities.deleteFolder(rootDir);
            System.exit(1);
        }
        for (int k = 0; k < maxrep; ++k) {
            s = "0" + s;
        }
        return s;
    }

    public static Map<Reference, Integer> calculateNumberOfIntervals(ReferenceSet rset) {
        TreeMap<Reference, Integer> ret = new TreeMap<Reference, Integer>();
        for (Reference r : rset.getRefs()) {
            int res = (int)(r.getLength() / 100000L);
            if (res % 100000 != 0 || res == 0) {
                ++res;
            }
            ret.put(r, res);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveAsFile(JFreeChart chart, File file) {
        FileOutputStream out = null;
        try {
            if (file.getParentFile() != null && !file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            out = new FileOutputStream(file);
            if (null != format) {
                switch (format) {
                    case png: {
                        ChartUtilities.writeChartAsPNG(out, chart, width, height);
                        break;
                    }
                    case jpeg: {
                        ChartUtilities.writeChartAsJPEG(out, chart, width, height);
                        break;
                    }
                    case pdf: {
                        Utilities.writeChartAsPDF(out, chart, width, height);
                        break;
                    }
                }
            }
            out.flush();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveAsFile(JFreeChart chart, File file, String table) {
        FileOutputStream out = null;
        int width = Utilities.width;
        int height = Utilities.height;
        try {
            if (file.getParentFile() != null && !file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            out = new FileOutputStream(file);
            if (null != format) {
                switch (format) {
                    case png: {
                        ChartUtilities.writeChartAsPNG(out, chart, width, height);
                        break;
                    }
                    case jpeg: {
                        ChartUtilities.writeChartAsJPEG(out, chart, width, height);
                        break;
                    }
                    case pdf: {
                        Utilities.writeChartAsPDF(out, chart, width, height);
                        break;
                    }
                }
            }
            out.flush();
            File tablefile = new File(file.getAbsolutePath().replaceAll(format.getExtension(), ".txt"));
            BufferedWriter bw = new BufferedWriter(new FileWriter(tablefile));
            bw.append(table);
            bw.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveAsFile(JFreeChart chart, File file, String table, PlotOrientation p) {
        int height;
        int width;
        FileOutputStream out = null;
        if (p == PlotOrientation.VERTICAL) {
            width = Utilities.width;
            height = Utilities.height;
        } else {
            width = Utilities.height;
            height = Utilities.width;
        }
        try {
            if (file.getParentFile() != null && !file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            out = new FileOutputStream(file);
            if (null != format) {
                switch (format) {
                    case png: {
                        ChartUtilities.writeChartAsPNG(out, chart, width, height);
                        break;
                    }
                    case jpeg: {
                        ChartUtilities.writeChartAsJPEG(out, chart, width, height);
                        break;
                    }
                    case pdf: {
                        Utilities.writeChartAsPDF(out, chart, width, height);
                        break;
                    }
                }
            }
            out.flush();
            File tablefile = new File(file.getAbsolutePath().replaceAll(format.getExtension(), ".txt"));
            BufferedWriter bw = new BufferedWriter(new FileWriter(tablefile));
            bw.append(table);
            bw.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeChartAsPDF(FileOutputStream output, JFreeChart chart, int width, int height) throws IOException {
        Rectangle pagesize = new Rectangle(width, height);
        try (Document document = new Document(pagesize, 50.0f, 50.0f, 50.0f, 50.0f);){
            PdfWriter writer = PdfWriter.getInstance(document, output);
            document.addAuthor("JFreeChart");
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            PdfTemplate tp = cb.createTemplate(width, height);
            Graphics2D g2 = tp.createGraphics(width, height);
            Rectangle2D.Double r2D = new Rectangle2D.Double(0.0, 0.0, width, height);
            chart.draw(g2, r2D);
            g2.dispose();
            cb.addTemplate(tp, 0.0f, 0.0f);
        }
    }

    private static char complement(char c) {
        switch (c) {
            case 'A': {
                return 'T';
            }
            case 'T': {
                return 'A';
            }
            case 'G': {
                return 'C';
            }
            case 'C': {
                return 'G';
            }
            case 'a': {
                return 'T';
            }
            case 't': {
                return 'A';
            }
            case 'g': {
                return 'C';
            }
            case 'c': {
                return 'G';
            }
        }
        return 'N';
    }

    public static String reverseComplement(String s) {
        int len = s.length();
        char[] s1 = new char[len];
        for (int i = len - 1; i >= 0; --i) {
            s1[len - i - 1] = Utilities.complement(s.charAt(i));
        }
        return new String(s1);
    }

    public static void waiter(List<File> files) {
        Set<File> tfiles = Collections.newSetFromMap(new ConcurrentHashMap());
        tfiles.addAll(files);
        while (!tfiles.isEmpty()) {
            for (File fi : tfiles) {
                if (!fi.exists()) continue;
                tfiles.remove(fi);
            }
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void safePrint(ScaffoldContig s) {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            System.out.print(s.toString(true));
        }
    }

    public static String getPrefix(File file) {
        return file.getName().split("\\.")[0];
    }

    static {
        ls = System.lineSeparator();
        submitJobs = Enums.ScriptRunMode.multithread;
        submitJobsParameters = "";
        indeldiscovery = false;
        alignmentTool = Enums.AlignmentTool.minimap2;
        format = ImageFormat.jpeg;
        contigAlignmentDraw = false;
        assignQuality = true;
        alignmentIdentityThreshold = 99;
        alignmentDistanceThreshold = 1000;
        initialAlignmentDistanceThreshold = 100;
        alignmentDistanceThresholdInc = 100;
        maxAlignmentDistanceThreshold = 10000;
        sizeratiodifference = 0.1;
        scaffoldinggapoverlapratio = 0.9;
        fastarecordlengththreshold = 0;
        alpha = 1.0;
        beta = 1.0;
        maxQScore = 1.0;
        sleepTime = 100;
        no_filterThreads = 4;
        no_threads = 4;
        no_ReaderThreads = 2;
        globalFilter = false;
        minContigLength = 10;
        maxContigLength = 10000000;
        lengthLevels = new TreeSet<Integer>();
        width = 1200;
        height = 800;
        no_hist_bins = 10;
        intervalLength4Histogram = maxQScore / (double)no_hist_bins;
        adder = new BigDecimal(intervalLength4Histogram);
        difference = 0.01;
        qlevel = new QUALLEVEL(1.0, 0.0, difference);
        numberFormatter.setRoundingMode(RoundingMode.HALF_EVEN);
        numberFormatter.setMaximumFractionDigits(3);
        numberFormatter.setGroupingUsed(false);
        numberFormatterSmall.setRoundingMode(RoundingMode.HALF_EVEN);
        numberFormatterSmall.setMaximumFractionDigits(20);
        numberFormatterSmall.setGroupingUsed(false);
    }
}

