/*
 * Decompiled with CFR 0.152.
 */
package org.fda.data;

import java.util.concurrent.TimeUnit;

public class TimePoint
implements Comparable<TimePoint> {
    private long start;
    private long end;
    private String label;

    public TimePoint(String label, long start) {
        this.label = label;
        this.start = start;
    }

    public String getLabel() {
        return this.label;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public void setEnd(long end) {
        this.end = end;
    }

    @Override
    public int compareTo(TimePoint o) {
        if (this.end < o.end) {
            return 1;
        }
        if (this.end > o.end) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        String lb = !this.label.equalsIgnoreCase("CMD") ? "Duration of " + this.label + "(in sec):\t" : "Total time(in sec):\t";
        return lb + TimeUnit.NANOSECONDS.toSeconds(this.end - this.start);
    }
}

