/*
 * Decompiled with CFR 0.152.
 */
package org.fda.data;

import java.io.File;
import java.io.Serializable;

public class Enums {

    public static enum Distribution {
        NORMAL,
        GAMMA,
        UNIFORM;

    }

    public static enum CoordType {
        START,
        END,
        BOTH;

    }

    public static enum ScriptRunMode {
        sbatch("sbatch"),
        qsub("qsub"),
        multithread("multithread");

        private final String cmd;

        private ScriptRunMode(String cmd) {
            this.cmd = cmd;
        }
    }

    public static enum GeneFormat {
        GFFV3,
        TAB_UCSC,
        GTF,
        TMP;

    }

    public static enum RunMode {
        merge,
        split;

    }

    public static enum FileMode implements Serializable
    {
        READONLY,
        WRITE;

        private static final long serialVersionUID = 35902182489L;
    }

    public static enum CoverageType implements Serializable
    {
        FULL,
        PARTIAL,
        NONE;

        private static final long serialVersionUID = 28411611902182489L;

        public static CoverageType getCoverageType(double overlap) {
            if (overlap == 100.0) {
                return FULL;
            }
            if (overlap == 0.0) {
                return NONE;
            }
            return PARTIAL;
        }
    }

    public static enum NLevel implements Serializable
    {
        N10(10.0),
        N20(20.0),
        N30(30.0),
        N40(40.0),
        N50(50.0),
        N60(60.0),
        N70(70.0),
        N80(80.0),
        N90(90.0),
        N100(100.0);

        private final double threshold;
        private static final long serialVersionUID = 82489L;

        private NLevel(double thr) {
            this.threshold = thr;
        }

        public double getThreshold() {
            return this.threshold;
        }

        public NLevel nextLevel() {
            if (this == N100) {
                return null;
            }
            return NLevel.valueOf("N" + ((int)this.getThreshold() + 10));
        }

        public NLevel prevLevel() {
            if (this == N10) {
                return null;
            }
            return NLevel.valueOf("N" + ((int)this.getThreshold() - 10));
        }

        public static NLevel minLevel() {
            return N10;
        }

        public static NLevel maxLevel() {
            return N100;
        }
    }

    public static enum LLevel implements Serializable
    {
        L10(10.0),
        L20(20.0),
        L30(30.0),
        L40(40.0),
        L50(50.0),
        L60(60.0),
        L70(70.0),
        L80(80.0),
        L90(90.0),
        L100(100.0);

        private final double threshold;
        private static final long serialVersionUID = 82489L;

        private LLevel(double thr) {
            this.threshold = thr;
        }

        public double getThreshold() {
            return this.threshold;
        }

        public LLevel nextLevel() {
            if (this == L100) {
                return null;
            }
            return LLevel.valueOf("L" + ((int)this.getThreshold() + 10));
        }

        public LLevel prevLevel() {
            if (this == L10) {
                return null;
            }
            return LLevel.valueOf("L" + ((int)this.getThreshold() - 10));
        }
    }

    public static enum LGLevel implements Serializable
    {
        LG10(10.0),
        LG20(20.0),
        LG30(30.0),
        LG40(40.0),
        LG50(50.0),
        LG60(60.0),
        LG70(70.0),
        LG80(80.0),
        LG90(90.0),
        LG100(100.0);

        private final double threshold;
        private static final long serialVersionUID = 82489L;

        private LGLevel(double thr) {
            this.threshold = thr;
        }

        public double getThreshold() {
            return this.threshold;
        }

        public LGLevel nextLevel() {
            if (this == LG100) {
                return null;
            }
            return LGLevel.valueOf("LG" + ((int)this.getThreshold() + 10));
        }

        public LGLevel prevLevel() {
            if (this == LG10) {
                return null;
            }
            return LGLevel.valueOf("LG" + ((int)this.getThreshold() - 10));
        }
    }

    public static enum NGLevel implements Serializable
    {
        NG10(10.0),
        NG20(20.0),
        NG30(30.0),
        NG40(40.0),
        NG50(50.0),
        NG60(60.0),
        NG70(70.0),
        NG80(80.0),
        NG90(90.0),
        NG100(100.0);

        private final double threshold;
        private static final long serialVersionUID = 82489L;

        private NGLevel(double thr) {
            this.threshold = thr;
        }

        public double getThreshold() {
            return this.threshold;
        }

        public NGLevel nextLevel() {
            if (this == NG100) {
                return null;
            }
            return NGLevel.valueOf("NG" + ((int)this.getThreshold() + 10));
        }

        public NGLevel prevLevel() {
            if (this == NG10) {
                return null;
            }
            return NGLevel.valueOf("NG" + ((int)this.getThreshold() - 10));
        }
    }

    public static enum RunCommand {
        ContigGenerate1,
        ContigGenerate2,
        ContigGenerate3,
        ContigGenerate4,
        ContigGenerate5,
        AssemblyReevaluate,
        AssemblyAlignAndEvaluate,
        ComputeModel,
        ChrPick,
        RecomputeModel,
        ShowModel,
        Filter,
        Misassemble;

    }

    public static enum Base {
        A,
        C,
        T,
        G;


        public Base complement() {
            switch (this) {
                case A: {
                    return T;
                }
                case T: {
                    return A;
                }
                case C: {
                    return G;
                }
                case G: {
                    return C;
                }
            }
            return null;
        }
    }

    public static enum Orientation implements Serializable
    {
        F('+'),
        R('-');

        private final char o;
        private static final long serialVersionUID = 911004102182489L;

        private Orientation(char o) {
            this.o = o;
        }

        public char getCharRepresentation() {
            return this.o;
        }
    }

    public static enum Inconsistency implements Serializable
    {
        TRANSLOCATION,
        RELOCATION,
        INVERSION,
        SCAFFOLD_GAP;

        private static final long serialVersionUID = -11004102182489L;

        public static String[] getValues() {
            return new String[]{"TRANSLOCATION", "RELOCATION", "INVERSION", "SCAFFOLD_GAP"};
        }
    }

    public static enum STOPOBJECT {
        STOP;

    }

    public static enum AlignmentTool {
        minimap2,
        nucmer;


        public String getFileExtension() {
            return this == minimap2 ? ".paf" : ".delta";
        }

        public String getFolder() {
            return this == minimap2 ? "minimap2" : "mummer";
        }

        public String[] getExec() {
            String[] stringArray;
            if (this == minimap2) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "minimap2";
            } else {
                String[] stringArray3 = new String[15];
                stringArray3[0] = "show-diff";
                stringArray3[1] = "promer";
                stringArray3[2] = "nucmer";
                stringArray3[3] = "exact-tandems";
                stringArray3[4] = "dnadiff";
                stringArray3[5] = "show-snps";
                stringArray3[6] = "show-tiling";
                stringArray3[7] = "show-coords";
                stringArray3[8] = "show-aligns";
                stringArray3[9] = "repeat-match";
                stringArray3[10] = "mgaps";
                stringArray3[11] = "delta-filter";
                stringArray3[12] = "combineMUMs";
                stringArray3[13] = "mummer";
                stringArray = stringArray3;
                stringArray3[14] = "annotate";
            }
            return stringArray;
        }

        public String[] getCompileCommand(File alignerDir) {
            String[] allcmds;
            if (this == nucmer) {
                String cdcmd = "cd " + alignerDir.getAbsolutePath();
                String configcmd = "./configure --prefix=" + alignerDir.getAbsolutePath();
                String makecmd = "make";
                allcmds = new String[]{"/bin/sh", "-c", cdcmd + ";" + configcmd + ";" + makecmd};
            } else {
                String makecmd = "make -C " + alignerDir.getAbsolutePath();
                allcmds = new String[]{makecmd};
            }
            return allcmds;
        }
    }

    public static enum AcceptedInputFileTypes {
        FASTQ("fastq"),
        FA("fa"),
        FASTA("fasta"),
        FASTAGZ("fasta.gz"),
        FAGZ("fa.gz"),
        FASTQGZ("fastq.gz");

        private final String file_extension;

        private AcceptedInputFileTypes(String extension) {
            this.file_extension = extension;
        }

        public String toString() {
            return this.file_extension;
        }
    }

    public static enum HashingAlgorithm {
        MD5("MD5"),
        SHA_1("SHA-1"),
        SHA_256("SHA-256");

        private final String algorithm;

        private HashingAlgorithm(String algorithm) {
            this.algorithm = algorithm;
        }

        public String toString() {
            return this.algorithm;
        }
    }
}

