/*
 * Decompiled with CFR 0.152.
 */
package org.fda.contiggenerator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import org.fda.data.Enums;
import org.fda.data.Utilities;
import org.fda.exceptions.IllegalIntervalException;
import org.fda.inputdataparser.FastaReader;
import org.fda.inputdataparser.FastaRecord;
import org.fda.inputdataparser.FastaWriter;
import org.fda.intervaltree.Interval;

public class MisassemblyGenerator {
    protected final File infile;
    protected final File outfile;
    protected final int threshold;
    protected final int avgMisNumber;

    public MisassemblyGenerator(File infile, File outfile, int threshold, int avgMisNumber) {
        this.infile = infile;
        this.outfile = outfile;
        this.threshold = threshold;
        this.avgMisNumber = avgMisNumber;
        File parent = outfile.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        FastaReader fr = new FastaReader();
        FastaWriter frw = new FastaWriter(this.outfile);
        try {
            FastaRecord r;
            BufferedWriter bw = new BufferedWriter(new FileWriter(new File(this.outfile.getAbsolutePath() + ".coords")));
            fr.openFile(this.infile);
            bw.append("Chr\tStart\tEnd\tOrientation" + Utilities.ls);
            while ((r = (FastaRecord)fr.readNextRecord()) != null) {
                this.misassemble(r, frw, bw);
            }
            fr.closeReader();
            bw.close();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        catch (IllegalIntervalException ex) {
            ex.printStackTrace();
        }
        finally {
            frw.closeWriter();
        }
    }

    private void misassemble(FastaRecord r, FastaWriter fw, BufferedWriter bw) throws IllegalIntervalException, IOException {
        int contiglength = r.getReadRecordLength();
        int partslen = contiglength / (this.avgMisNumber + 1);
        ArrayList<Interval> intArr = new ArrayList<Interval>();
        ArrayList<Enums.Orientation> orArr = new ArrayList<Enums.Orientation>();
        int st = 1;
        for (int i = 0; i <= this.avgMisNumber; ++i) {
            if (i == this.avgMisNumber) {
                intArr.add(new Interval(st, contiglength, false));
            } else {
                intArr.add(new Interval(st, st + partslen - 1, false));
            }
            st += partslen;
            orArr.add(Enums.Orientation.F);
        }
        Random rand = new Random();
        for (int i = 0; i < intArr.size() - 1; ++i) {
            double randno = rand.nextDouble();
            boolean done = false;
            while (!done) {
                if (randno < 0.33) {
                    try {
                        if (rand.nextDouble() > 0.5) {
                            ((Interval)intArr.get(i)).sethigh(Math.min(((Interval)intArr.get(i)).gethigh() + 2 * this.threshold, contiglength));
                        } else {
                            ((Interval)intArr.get(i + 1)).setlow(Math.max(((Interval)intArr.get(i + 1)).getlow() - 2 * this.threshold, 1));
                        }
                        done = true;
                    }
                    catch (IllegalIntervalException ie) {
                        randno += 0.33;
                    }
                    continue;
                }
                if (randno < 0.66) {
                    try {
                        if (rand.nextDouble() > 0.5) {
                            ((Interval)intArr.get(i)).sethigh(((Interval)intArr.get(i)).gethigh() - 2 * this.threshold);
                        } else {
                            ((Interval)intArr.get(i + 1)).setlow(((Interval)intArr.get(i + 1)).getlow() + 2 * this.threshold);
                        }
                        done = true;
                    }
                    catch (IllegalIntervalException ie) {
                        randno += 0.33;
                    }
                    continue;
                }
                for (int j = i + 1; j < intArr.size(); ++j) {
                    if (orArr.get(j) == Enums.Orientation.F) {
                        orArr.set(j, Enums.Orientation.R);
                        continue;
                    }
                    orArr.set(j, Enums.Orientation.F);
                }
                done = true;
            }
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < intArr.size(); ++i) {
            String tmpstr = r.getRead().substring(((Interval)intArr.get(i)).getlow() - 1, ((Interval)intArr.get(i)).gethigh());
            if (orArr.get(i) == Enums.Orientation.R) {
                sb.append(Utilities.reverseComplement(tmpstr));
            } else {
                sb.append(tmpstr);
            }
            bw.append(r.getName() + "\t" + ((Interval)intArr.get(i)).getlow() + "\t" + ((Interval)intArr.get(i)).gethigh() + "\t" + orArr.get(i) + Utilities.ls);
        }
        FastaRecord frec = new FastaRecord(r.getHeader(), sb.toString());
        fw.write(frec);
    }

    public static void main(String[] args) {
        File infile = new File("contigs1.fa");
        File outfile = new File("out.fa");
        int misThre = 1000;
        int number = 200;
        MisassemblyGenerator mg = new MisassemblyGenerator(infile, outfile, misThre, number);
        mg.process();
    }
}

