/*
 * Decompiled with CFR 0.152.
 */
package org.fda.contiggenerator;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.fda.contiggenerator.ContigDetails;
import org.fda.contiggenerator.ContigGeneratorInterface;
import org.fda.contiggenerator.ContigGeneratorWDistribution;
import org.fda.data.Enums;
import org.fda.data.Utilities;
import org.fda.exceptions.IllegalIntervalException;
import org.fda.inputdataparser.FastaReader;
import org.fda.inputdataparser.FastaRecord;
import org.fda.inputdataparser.FastaWriter;
import org.fda.intervaltree.Interval;

public class ContigGenerator4
extends ContigGeneratorWDistribution
implements ContigGeneratorInterface {
    private final int maxiteration = 1000;
    private final boolean isRandom;

    public ContigGenerator4(File infile, File outfile, double mean, double sd, Enums.Distribution dist, boolean isRandom) {
        super(infile, outfile, mean, sd, dist);
        this.isRandom = isRandom;
    }

    public ContigGenerator4(File infile, File outfile, double mean, double sd, Enums.Distribution dist, boolean isRandom, boolean createreport) {
        super(infile, outfile, mean, sd, dist, createreport);
        this.isRandom = isRandom;
    }

    public ContigGenerator4(File infile, File outfile, double mean, double sd, Enums.Distribution dist, long seed, boolean isRandom) {
        super(infile, outfile, mean, sd, dist, seed);
        this.isRandom = isRandom;
    }

    public ContigGenerator4(File infile, File outfile, double mean, double sd, Enums.Distribution dist, long seed, boolean isRandom, boolean createreport) {
        super(infile, outfile, mean, sd, dist, seed, createreport);
        this.isRandom = isRandom;
    }

    public ContigGenerator4(File infile, File outfile, double mean, double sd, Enums.Distribution dist, boolean setseed, boolean isRandom, boolean createreport) {
        super(infile, outfile, mean, sd, dist, setseed, createreport);
        this.isRandom = isRandom;
    }

    protected List<String> createContigsOnReference(FastaRecord r, FastaWriter frw, double cov_perc) throws IllegalIntervalException {
        boolean full = false;
        if (cov_perc == 1.0) {
            full = true;
        }
        int st = 1;
        Interval res = null;
        ArrayList<Interval> currcontigcoords = new ArrayList<Interval>();
        boolean contnumber = false;
        ArrayList<String> contigids = new ArrayList<String>();
        long curr_covered_size = 0L;
        while (st <= r.getReadRecordLength()) {
            double curr_rat;
            Interval inte = new Interval(st, st, false);
            res = r.getnIntervalsTree().search(inte);
            if (res != null) {
                if (r.getReadRecordLength() == res.gethigh()) break;
                st = res.gethigh() + 1;
                continue;
            }
            int length = !full ? this.getRandomLength(r.getReadRecordLength(), cov_perc, curr_covered_size) : this.getRandomLength(r.getReadRecordLength());
            int end = st + length - 1;
            int cnt = 1;
            while (end > r.getReadRecordLength()) {
                if (cnt > this.maxiteration) {
                    end = r.getReadRecordLength();
                    break;
                }
                length = !full ? this.getRandomLength(r.getReadRecordLength(), cov_perc, curr_covered_size) : this.getRandomLength(r.getReadRecordLength());
                end = st + length - 1;
                ++cnt;
            }
            inte = new Interval(st, end, false);
            List<Interval> intervals = r.getnIntervalsTree().searchAll(inte);
            Collections.sort(intervals);
            int ntot = 0;
            for (Interval it : intervals) {
                ntot += inte.overlap(it);
            }
            double nrat = (double)ntot / (double)inte.getlength();
            if (nrat <= Utilities.nratio) {
                currcontigcoords.add(inte);
                curr_covered_size += (long)inte.getlength();
                st = end + 1;
            } else {
                boolean found = false;
                if (r.getRead().charAt(end - 1) == 'N') {
                    ntot = ntot + intervals.get(intervals.size() - 1).gethigh() - end;
                }
                for (int k = intervals.size() - 1; k >= 0; --k) {
                    end = intervals.get(k).gethigh();
                    Interval curr = intervals.get(k);
                    int displacement = this.calculateNewEndPos(end - st + 1, ntot);
                    int pos = end - displacement;
                    if (pos >= curr.getlow() - 1 && displacement > 0) {
                        inte = new Interval(st, pos, false);
                        currcontigcoords.add(inte);
                        curr_covered_size += (long)inte.getlength();
                        st = intervals.get(k).gethigh() + 1;
                        found = true;
                        break;
                    }
                    ntot -= intervals.get(k).getlength();
                }
                if (!found) {
                    end = intervals.get(0).getlow() - 1;
                    inte = new Interval(st, end, false);
                    currcontigcoords.add(inte);
                    curr_covered_size += (long)inte.getlength();
                    st = intervals.get(0).gethigh() + 1;
                }
            }
            if (!(cov_perc < 1.0) || !((curr_rat = (double)curr_covered_size / (double)r.getReadRecordLength()) <= cov_perc * (1.0 + Utilities.simulation_coverage_ratio_threshold)) || !(curr_rat >= cov_perc * (1.0 - Utilities.simulation_coverage_ratio_threshold))) continue;
            break;
        }
        int currpos = 0;
        Interval newint = null;
        do {
            if (((Interval)currcontigcoords.get(currpos)).getlength() < Utilities.simulation_mincontiglength) {
                if (currpos == 0) {
                    ++currpos;
                    continue;
                }
                newint = this.merge((Interval)currcontigcoords.get(currpos - 1), (Interval)currcontigcoords.get(currpos));
                if (newint != null) {
                    currcontigcoords.add(currpos + 1, newint);
                    currcontigcoords.remove(currpos - 1);
                    currcontigcoords.remove(currpos - 1);
                    continue;
                }
                ++currpos;
                continue;
            }
            ++currpos;
        } while (currpos < currcontigcoords.size());
        for (Interval i : currcontigcoords) {
            ++this.totcontnumber;
            String s = r.getRead().substring(i.getlow() - 1, i.gethigh());
            Enums.Orientation or = this.rand.nextDouble() < 0.5 ? Enums.Orientation.F : Enums.Orientation.R;
            String fin = or == Enums.Orientation.R ? Utilities.reverseComplement(s) : s;
            FastaRecord frec = new FastaRecord(">contig" + this.totcontnumber, fin);
            contigids.add(frec.getName());
            this.totalN += (long)frec.getNcount();
            ContigDetails tmp = new ContigDetails(frec.getName(), r.getName(), i, or, frec.getNcount(), frec.getNratio());
            this.finalcontigcoords.add(tmp);
            this.totsize += (long)frec.getReadRecordLength();
            frw.write(frec);
            this.add2Lengths(tmp);
        }
        return contigids;
    }

    private Interval merge(Interval a, Interval b) {
        double nonnlen = a.getlength() + b.getlength();
        double totlen = b.gethigh() - a.getlow() + 1;
        double nrat = (totlen - nonnlen) / totlen;
        Interval ret = null;
        if (nrat < Utilities.nratio) {
            try {
                ret = new Interval(a.getlow(), b.gethigh(), false);
            }
            catch (IllegalIntervalException ex) {
                ex.printStackTrace();
            }
        }
        return ret;
    }

    private int calculateNewEndPos(int intervallength, int nlength) {
        double d = (Utilities.nratio * (double)intervallength - (double)nlength) / (Utilities.nratio - 1.0);
        return (int)d;
    }

    private void createRandomContigs(FastaRecord r, FastaWriter frw) throws IllegalIntervalException {
        FastaRecord frec;
        long totTargetBp = (long)(Utilities.depthCoverage * (double)r.getReadRecordLength());
        int totalIterationCnt = 0;
        int seqlen = r.getReadRecordLength();
        int totgeneratedcontignumber = 0;
        boolean contnumber = false;
        block2: for (long totgeneratedbp = 0L; totgeneratedbp < totTargetBp; totgeneratedbp += (long)frec.getReadRecordLength()) {
            int contlen;
            if (totalIterationCnt > 1000) {
                System.out.println("Error: this many contigs couldn't be generated with the given parameters from this reference chromosome" + r.getName() + " after " + totalIterationCnt + " iterations");
                if (totgeneratedcontignumber == 0) {
                    System.out.println("No contigs could be generated " + r.getName());
                    break;
                }
                System.out.println(totgeneratedcontignumber + " contigs were generated on " + r.getName());
                break;
            }
            for (int iteration = 0; !((double)((long)(contlen = this.getRandomLength(r.getReadRecordLength())) + totgeneratedbp) <= 1.05 * (double)totTargetBp) && iteration < 100; ++iteration) {
            }
            while (true) {
                if (totalIterationCnt > 1000) {
                    System.out.println("Error: this many contigs couldn't be generated with the given parameters from this reference chromosome" + r.getName() + " after " + totalIterationCnt + " iterations");
                    if (totgeneratedcontignumber == 0) {
                        System.out.println("No contigs could be generated on " + r.getName());
                        break block2;
                    }
                    System.out.println(totgeneratedcontignumber + " contigs were generated on " + r.getName());
                    break block2;
                }
                int st = this.rand.nextInt(seqlen);
                int end = st + contlen;
                if (end > seqlen) {
                    ++totalIterationCnt;
                    continue;
                }
                try {
                    Interval inte = new Interval(st + 1, end, false);
                    List<Interval> intervals = r.getnIntervalsTree().searchAll(inte);
                    Collections.sort(intervals);
                    int ntot = 0;
                    for (Interval it : intervals) {
                        ntot += inte.overlap(it);
                    }
                    double nrat = (double)ntot / (double)inte.getlength();
                    if (nrat <= Utilities.nratio) {
                        ++totgeneratedcontignumber;
                        ++this.totcontnumber;
                        String s = r.getRead().substring(inte.getlow() - 1, inte.gethigh());
                        Enums.Orientation or = Math.random() < 0.5 ? Enums.Orientation.F : Enums.Orientation.R;
                        String fin = or == Enums.Orientation.R ? Utilities.reverseComplement(s) : s;
                        frec = new FastaRecord(">contig" + this.totcontnumber, fin);
                        this.totalN += (long)frec.getNcount();
                        ContigDetails tmp = new ContigDetails(frec.getName(), r.getName(), inte, or, frec.getNcount(), frec.getNratio());
                        this.finalcontigcoords.add(tmp);
                        this.totsize += (long)frec.getReadRecordLength();
                        frw.write(frec);
                        this.add2Lengths(tmp);
                        continue block2;
                    }
                    ++totalIterationCnt;
                }
                catch (IllegalIntervalException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateContigs() {
        FastaReader fr = new FastaReader();
        FastaWriter frw = new FastaWriter(this.outfile);
        int w = (int)Utilities.depthCoverage;
        double f = Utilities.depthCoverage - (double)w;
        try {
            FastaRecord r;
            fr.openFile(this.infile);
            while ((r = (FastaRecord)fr.readNextRecord()) != null) {
                this.totalNReference += (long)r.getNcount();
                ++this.totrefnumber;
                this.totrefsize += (long)r.getReadRecordLength();
                if (this.isRandom) {
                    this.createRandomContigs(r, frw);
                    continue;
                }
                for (int i = 0; i < w; ++i) {
                    if (this.setseed) {
                        this.rand.setSeed((long)r.getReadRecordLength() + (long)i);
                    }
                    this.createContigsOnReference(r, frw, 1.0);
                }
                if (f == 0.0) continue;
                if (this.setseed) {
                    this.rand.setSeed((long)r.getReadRecordLength() - 1L);
                }
                this.createContigsOnReference(r, frw, f);
            }
            fr.closeReader();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        catch (IllegalIntervalException ex) {
            ex.printStackTrace();
        }
        finally {
            frw.closeWriter();
        }
        this.report();
    }

    public void setCoverage(double d) {
        Utilities.depthCoverage = d;
    }

    public static void main(String[] args) {
        Utilities.nratio = 0.5;
        ContigGenerator4 g = new ContigGenerator4(new File("hg38.fa"), new File("out.fa"), 1.0E7, 1.0E7, Enums.Distribution.NORMAL, false, false, true);
        g.setCoverage(0.4);
        g.generateContigs();
    }
}

