/*
 * Decompiled with CFR 0.152.
 */
package org.fda.contiggenerator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.fda.contiggenerator.ContigDetails;
import org.fda.contiggenerator.ContigGenerator;
import org.fda.contiggenerator.ContigGeneratorInterface;
import org.fda.data.Enums;
import org.fda.data.Utilities;
import org.fda.exceptions.IllegalIntervalException;
import org.fda.inputdataparser.FastaReader;
import org.fda.inputdataparser.FastaRecord;
import org.fda.inputdataparser.FastaWriter;
import org.fda.intervaltree.Interval;
import org.fda.intervaltree.IntervalSearchTree;

public class ContigGenerator2
extends ContigGenerator
implements ContigGeneratorInterface {
    private final Map<String, List<Integer>> totalContigNumberMap;
    private final int maxIterationLimit = 200;

    public ContigGenerator2(File infile, File outfile, File f) {
        super(infile, outfile);
        this.totalContigNumberMap = this.parseInput(f);
    }

    public ContigGenerator2(File infile, File outfile, File f, boolean createreport) {
        super(infile, outfile, createreport);
        this.totalContigNumberMap = this.parseInput(f);
    }

    private Map<String, List<Integer>> parseInput(File f) {
        HashMap<String, List<Integer>> nMap = new HashMap<String, List<Integer>>();
        try (BufferedReader br = new BufferedReader(new FileReader(f));){
            String line;
            ArrayList<Integer> lst = null;
            String name = null;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                if (line.startsWith(">")) {
                    if (lst != null) {
                        nMap.put(name, (List<Integer>)lst);
                    }
                    lst = new ArrayList<Integer>();
                    name = line.substring(1);
                    continue;
                }
                lst.add(Integer.parseInt(line));
            }
            nMap.put(name, lst);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateContigs() {
        FastaReader fr = new FastaReader();
        FastaWriter frw = new FastaWriter(this.outfile);
        try {
            FastaRecord r;
            fr.openFile(this.infile);
            while ((r = (FastaRecord)fr.readNextRecord()) != null) {
                this.totalNReference += (long)r.getNcount();
                ++this.totrefnumber;
                this.totrefsize += (long)r.getReadRecordLength();
                if (this.totalContigNumberMap.containsKey(r.getName())) {
                    this.createContigsOnReference(r, frw, this.totalContigNumberMap.get(r.getName()));
                    continue;
                }
                System.out.println("Skipping reference sequence " + r.getName());
            }
            fr.closeReader();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        catch (IllegalIntervalException ex) {
            ex.printStackTrace();
        }
        finally {
            frw.closeWriter();
        }
        this.report();
    }

    private void createContigsOnReference(FastaRecord r, FastaWriter frw, List<Integer> lengthArr) throws IllegalIntervalException {
        int maxItLimit = this.maxIterationLimit * lengthArr.size();
        int totalIterationCnt = 0;
        int seqlen = r.getReadRecordLength();
        IntervalSearchTree ist = new IntervalSearchTree();
        int totgeneratedcontnumber = 0;
        Random rand = new Random();
        boolean contnumber = false;
        block2: while (totgeneratedcontnumber < lengthArr.size()) {
            if (totalIterationCnt > maxItLimit) {
                System.out.println("Error: this many contigs couldn't be generated with the given parameters from this reference chromosome" + r.getName() + " after " + totalIterationCnt + " iterations");
                if (totgeneratedcontnumber == 0) {
                    System.out.println("No contigs could be generated " + r.getName());
                    break;
                }
                System.out.println(totgeneratedcontnumber + " contigs were generated on " + r.getName());
                break;
            }
            int contlen = lengthArr.get(totgeneratedcontnumber);
            while (true) {
                if (totalIterationCnt > maxItLimit) {
                    System.out.println("Error: this many contigs couldn't be generated with the given parameters from this reference chromosome" + r.getName() + " after " + totalIterationCnt + " iterations");
                    if (totgeneratedcontnumber == 0) {
                        System.out.println("No contigs could be generated on " + r.getName());
                        break block2;
                    }
                    System.out.println(totgeneratedcontnumber + " contigs were generated on " + r.getName());
                    break block2;
                }
                int st = rand.nextInt(seqlen);
                int end = st + contlen;
                if (end > seqlen) {
                    ++totalIterationCnt;
                    continue;
                }
                try {
                    Interval inte = new Interval(st + 1, end, false);
                    List<Interval> intervals = r.getnIntervalsTree().searchAll(inte);
                    Collections.sort(intervals);
                    int ntot = 0;
                    for (Interval it : intervals) {
                        ntot += inte.overlap(it);
                    }
                    double nrat = (double)ntot / (double)inte.getlength();
                    if (nrat <= Utilities.nratio) {
                        if (!Utilities.contigsOverlap) {
                            if (ist.search(inte) == null) {
                                ist.put(inte);
                            } else {
                                ++totalIterationCnt;
                                continue;
                            }
                        }
                        ++totgeneratedcontnumber;
                        ++this.totcontnumber;
                        String s = r.getRead().substring(inte.getlow() - 1, inte.gethigh());
                        Enums.Orientation or = rand.nextDouble() < 0.5 ? Enums.Orientation.F : Enums.Orientation.R;
                        String fin = or == Enums.Orientation.R ? Utilities.reverseComplement(s) : s;
                        FastaRecord frec = new FastaRecord(">contig" + this.totcontnumber, fin);
                        this.totalN += (long)frec.getNcount();
                        ContigDetails tmp = new ContigDetails(frec.getName(), r.getName(), inte, or, frec.getNcount(), frec.getNratio());
                        this.finalcontigcoords.add(tmp);
                        this.totsize += (long)frec.getReadRecordLength();
                        frw.write(frec);
                        this.add2Lengths(tmp);
                        continue block2;
                    }
                    ++totalIterationCnt;
                }
                catch (IllegalIntervalException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

