/*
 * Decompiled with CFR 0.152.
 */
package org.fda.contiggenerator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fda.contiggenerator.ContigDetails;
import org.fda.contiggenerator.ContigGenerator;
import org.fda.contiggenerator.ContigGeneratorInterface;
import org.fda.data.Enums;
import org.fda.data.Utilities;
import org.fda.exceptions.IllegalIntervalException;
import org.fda.inputdataparser.FastaReader;
import org.fda.inputdataparser.FastaRecord;
import org.fda.inputdataparser.FastaWriter;
import org.fda.intervaltree.Interval;

public class ContigGenerator1
extends ContigGenerator
implements ContigGeneratorInterface {
    private Map<String, List<ContigDetails>> intervalsMap = new HashMap<String, List<ContigDetails>>();

    private ContigDetails parseInterval(String line) throws IllegalIntervalException {
        String[] top = line.split("\t");
        String name = top[0];
        Enums.Orientation or = Enums.Orientation.valueOf(top[2]);
        String[] ar1 = top[1].split(":");
        String refname = ar1[0];
        String[] coords = ar1[1].split("-");
        int st = Integer.parseInt(coords[0]);
        int end = Integer.parseInt(coords[1]);
        return new ContigDetails(name, refname, new Interval(st, end, false), or, 0, 0.0);
    }

    private void init(File f) {
        try (BufferedReader br = new BufferedReader(new FileReader(f));){
            String line = br.readLine();
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                ContigDetails tmp = this.parseInterval(line);
                if (this.intervalsMap.containsKey(tmp.getRefname())) {
                    this.intervalsMap.get(tmp.getRefname()).add(tmp);
                } else {
                    ArrayList<ContigDetails> tmpList = new ArrayList<ContigDetails>();
                    tmpList.add(tmp);
                    this.intervalsMap.put(tmp.getRefname(), tmpList);
                }
                this.add2Lengths(tmp);
            }
        }
        catch (IOException | IllegalIntervalException ex) {
            ex.printStackTrace();
        }
        this.totcontnumber = this.lengths.size();
    }

    public ContigGenerator1(File infile, File outfile, File f) {
        super(infile, outfile);
        this.init(f);
    }

    public ContigGenerator1(File infile, File outfile, File f, boolean createreport) {
        super(infile, outfile, createreport);
        this.init(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateContigs() {
        FastaReader fr = new FastaReader();
        FastaWriter frw = new FastaWriter(this.outfile);
        try {
            FastaRecord r;
            fr.openFile(this.infile);
            while ((r = (FastaRecord)fr.readNextRecord()) != null) {
                this.totrefsize += (long)r.getReadRecordLength();
                ++this.totrefnumber;
                this.totalNReference += (long)r.getNcount();
                List<ContigDetails> intervalsList = this.intervalsMap.get(r.getName());
                if (intervalsList == null) continue;
                for (int i = 0; i < intervalsList.size(); ++i) {
                    ContigDetails cd = intervalsList.get(i);
                    Interval it = intervalsList.get(i).getIr();
                    Enums.Orientation or = intervalsList.get(i).getOr();
                    String s = r.getRead().substring(it.getlow() - 1, it.gethigh());
                    if (or == Enums.Orientation.R) {
                        s = Utilities.reverseComplement(s);
                    }
                    FastaRecord frec = new FastaRecord(">" + intervalsList.get(i).getName(), s);
                    this.finalcontigcoords.add(new ContigDetails(cd.getName(), cd.getRefname(), cd.getIr(), cd.getOr(), frec.getNcount(), frec.getNratio()));
                    this.totsize += (long)frec.getReadRecordLength();
                    this.totalN += (long)frec.getNcount();
                    frw.write(frec);
                }
            }
            fr.closeReader();
            this.report();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        finally {
            frw.closeWriter();
        }
    }
}

