/*
 * Decompiled with CFR 0.152.
 */
package org.fda.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.converters.FileConverter;
import java.io.File;
import org.fda.commands.Command;
import org.fda.data.Enums;
import org.fda.data.Utilities;
import org.fda.functionality.AlphaValidator;
import org.fda.functionality.PositiveReal;

@Parameters(commandDescription="Contig Generate command type 5. This command can generate contigs using UNIFORM distribution with the a contig that can be generated from a chromosome can be at as long as the chromosome itself and as short as 500bp")
public class ContigGenerateCommand5
extends Command {
    @Parameter(names={"-f", "--infile"}, description="Input reference file path", required=true, converter=FileConverter.class)
    protected File inputFile;
    @Parameter(names={"-o", "--outfile"}, description="Output contig file path", required=false, converter=FileConverter.class)
    protected File outputFile = new File("contigs.fa");
    @Parameter(names={"-x", "--coverage"}, description="Depth of coverage ", required=false, validateWith=PositiveReal.class)
    protected Double coverage = Utilities.depthCoverage;
    @Parameter(names={"-g", "--nratio"}, description="The allowed percentage of the Ns in a contig", required=false, validateWith=AlphaValidator.class)
    protected final double nratio = Utilities.nratio;
    protected File destinationFolder = new File(System.getProperty("user.dir"));

    public double getNratio() {
        return this.nratio;
    }

    public ContigGenerateCommand5() {
        this.rcmd = Enums.RunCommand.ContigGenerate5;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public double getCoverage() {
        return this.coverage;
    }

    public File getDestinationFolder() {
        return this.destinationFolder;
    }
}

