/*
 * Decompiled with CFR 0.152.
 */
package org.fda.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.converters.FileConverter;
import java.io.File;
import org.fda.commands.Command;
import org.fda.data.Enums;
import org.fda.data.Utilities;
import org.fda.functionality.AlphaValidator;

@Parameters(commandDescription="Contig Generate command type 2 with given desired contig lengths as input. The contigs' coordinates are randomly selected on the reference")
public class ContigGenerateCommand2
extends Command {
    @Parameter(names={"-f", "--infile"}, description="Input reference file path", required=true, converter=FileConverter.class)
    protected File inputFile;
    @Parameter(names={"-o", "--outfile"}, description="Output contig file path", required=false, converter=FileConverter.class)
    protected File outputFile = new File("contigs.fa");
    @Parameter(names={"-l", "--contiglenfile"}, description="Input contig length distribution file", required=true, converter=FileConverter.class)
    protected File inputContigLengthFile = null;
    @Parameter(names={"-w", "--contigsoverlap"}, description="Generated contigs allowed to overlap or not?", required=false)
    protected final boolean contigsOverlap = Utilities.contigsOverlap;
    @Parameter(names={"-g", "--nratio"}, description="The allowed percentage of the Ns in a contig", required=false, validateWith=AlphaValidator.class)
    protected final double nratio = Utilities.nratio;
    protected File destinationFolder = new File(System.getProperty("user.dir"));

    public double getNratio() {
        return this.nratio;
    }

    public File getInputContigLengthFile() {
        return this.inputContigLengthFile;
    }

    public ContigGenerateCommand2() {
        this.rcmd = Enums.RunCommand.ContigGenerate2;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public File getDestinationFolder() {
        return this.destinationFolder;
    }

    public boolean doesContigsOverlap() {
        return this.contigsOverlap;
    }
}

