/*
 * Decompiled with CFR 0.152.
 */
package org.fda.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.converters.FileConverter;
import com.beust.jcommander.validators.PositiveInteger;
import java.io.File;
import org.fda.commands.Command;
import org.fda.data.Enums;
import org.fda.data.Utilities;
import org.fda.functionality.AlignmentToolConverter;
import org.fda.functionality.ScriptRunModeConverter;

@Parameters(commandDescription="Given a reference compute a multiple linear regression model to be used in evaluation")
public class ComputeModelCommand
extends Command {
    @Parameter(names={"-r", "--referencefile"}, description="Input reference file path", required=true, converter=FileConverter.class)
    protected File inputFile;
    @Parameter(names={"-q", "--alignmentTool"}, description="Tool used for the alignment of the contigs/scaffolds back to reference", required=false, converter=AlignmentToolConverter.class)
    private Enums.AlignmentTool alignmentTool = Utilities.alignmentTool;
    @Parameter(names={"-d", "--modeldestfolder"}, description="Model file destination directory", required=false, converter=FileConverter.class)
    protected File destinationFolder = new File("MODEL");
    @Parameter(names={"-j", "--jobcommand"}, description="Alignment job submission command", required=false, converter=ScriptRunModeConverter.class)
    protected Enums.ScriptRunMode jobcommand = Utilities.submitJobs;
    @Parameter(names={"-p", "--jobcommandparams"}, description="Alignment job submission command parameters in quotes", required=false)
    protected String jobcommandparams = Utilities.submitJobsParameters;
    @Parameter(names={"-t", "--threadno"}, description="Number of threads", required=false, validateWith=PositiveInteger.class)
    protected int t = Utilities.no_threads;

    public Enums.AlignmentTool getAlignmentTool() {
        return this.alignmentTool;
    }

    public int getThreadNo() {
        return this.t;
    }

    public Enums.ScriptRunMode getJobCommand() {
        return this.jobcommand;
    }

    public String getJobCommandParams() {
        return this.jobcommandparams;
    }

    public ComputeModelCommand() {
        this.rcmd = Enums.RunCommand.ComputeModel;
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public File getDestinationFolder() {
        return this.destinationFolder;
    }
}

