/*
 * Decompiled with CFR 0.152.
 */
package org.fda.basicstats;

import java.io.File;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.fda.basicstats.ContigRecord;
import org.fda.data.Enums;
import org.fda.data.Utilities;

public class BasicStatsComputeFromList {
    private final List<ContigRecord> contigLengths;
    private double mean = 0.0;
    private int median = 0;
    private int min = 0;
    private int max = 0;
    private final Map<Enums.NLevel, Integer> nlevels;
    private final Map<Enums.LLevel, Integer> llevels;
    private int contigNo = 0;
    private long totalcontigSize = 0L;
    private final File cumulativeContigSizeFile;
    private long total_gc_count = 0L;
    private double total_gc_percent = 0.0;
    private final int level;
    private double maxPenaltyValue = 0.0;

    public long getTotalcontigSize() {
        return this.totalcontigSize;
    }

    public synchronized void setMaxPenaltyValue(double d) {
        if (this.maxPenaltyValue < d) {
            this.maxPenaltyValue = d;
        }
    }

    public double getMaxPenaltyValue() {
        return this.maxPenaltyValue;
    }

    public BasicStatsComputeFromList(List<ContigRecord> contigLengths, int level) {
        this.contigLengths = contigLengths;
        this.nlevels = new TreeMap<Enums.NLevel, Integer>();
        this.llevels = new TreeMap<Enums.LLevel, Integer>();
        this.level = level;
        this.cumulativeContigSizeFile = new File(Utilities.rootDir.getAbsolutePath() + File.separator + "RESULTS" + File.separator + "L" + level + File.separator + "cumlength.bin");
        this.computeStats();
    }

    public int getNumberofContigs() {
        return this.contigNo;
    }

    public Map<Enums.NLevel, Integer> getNLevels() {
        return this.nlevels;
    }

    public long getTotalGCcount() {
        return this.total_gc_count;
    }

    public double getTotalGCpercent() {
        return this.total_gc_percent;
    }

    public double getMean() {
        return this.mean;
    }

    public int getMedian() {
        return this.median;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    private void setGCPercent() {
        this.total_gc_percent = 100.0 * (double)this.total_gc_count / (double)this.getTotalcontigSize();
    }

    private void setBasics() {
        boolean first = true;
        ArrayList<ContigRecord> tmplist = new ArrayList<ContigRecord>();
        try (RandomAccessFile out = new RandomAccessFile(this.cumulativeContigSizeFile, "rw");){
            out.writeInt(0);
            for (int i = this.contigLengths.size() - 1; i >= 0; --i) {
                int curr = this.contigLengths.get(i).getLength();
                if (curr < this.level) continue;
                tmplist.add(this.contigLengths.get(i));
                ++this.contigNo;
                this.totalcontigSize += (long)this.contigLengths.get(i).getLength();
                this.total_gc_count += (long)this.contigLengths.get(i).getGCCount();
                out.writeLong(this.totalcontigSize);
                if (first) {
                    this.min = this.max = curr;
                    first = false;
                    continue;
                }
                if (curr < this.min) {
                    this.min = curr;
                }
                if (curr <= this.max) continue;
                this.max = curr;
            }
            out.seek(0L);
            out.writeInt(this.contigNo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mean = (double)this.totalcontigSize / (double)this.contigNo;
        this.median = !tmplist.isEmpty() ? ((ContigRecord)tmplist.get(tmplist.size() / 2)).getLength() : -1;
        this.total_gc_percent = Utilities.calcPercentage(this.total_gc_count, this.totalcontigSize);
    }

    private void computeStats() {
        this.setBasics();
        Enums.NLevel Ngoal = Enums.NLevel.N10;
        Enums.LLevel Lgoal = Enums.LLevel.L10;
        double temp = 0.0;
        int count = 0;
        for (int i = this.contigLengths.size() - 1; i >= 0; --i) {
            if (this.contigLengths.get(i).getLength() <= this.level) continue;
            ++count;
            temp += (double)this.contigLengths.get(i).getLength();
            if (Ngoal == null || !(Utilities.calcPercentage(temp, (double)this.totalcontigSize) >= Ngoal.getThreshold())) continue;
            this.nlevels.put(Ngoal, this.contigLengths.get(i).getLength());
            this.llevels.put(Lgoal, count);
            Ngoal = Ngoal.nextLevel();
            Lgoal = Lgoal.nextLevel();
        }
        if (Ngoal != null) {
            Enums.NLevel tmp = Ngoal.prevLevel();
            Enums.LLevel tmp2 = Lgoal.prevLevel();
            while (Ngoal != null) {
                this.nlevels.put(Ngoal, this.nlevels.get(tmp));
                this.llevels.put(Lgoal, this.llevels.get(tmp2));
                Ngoal = Ngoal.nextLevel();
                Lgoal = Lgoal.nextLevel();
            }
        }
    }
}

