/*
 * Decompiled with CFR 0.152.
 */
package org.fda.basicstats;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.fda.basicstats.ContigRecord;
import org.fda.commands.AlignEvalCommand;
import org.fda.data.Enums;
import org.fda.data.Utilities;
import org.fda.inputdataparser.FastaRecord;
import org.fda.inputdataparser.ReadRecord;

public class BasicStatsCompute {
    private ContigRecord[] contigRecordsArray;
    private long sum = 0L;
    private double mean = 0.0;
    private int min = Integer.MAX_VALUE;
    private int max = 0;
    private final Map<Enums.NLevel, Integer> nlevels = new TreeMap<Enums.NLevel, Integer>();
    private final Map<Enums.LLevel, Integer> llevels = new TreeMap<Enums.LLevel, Integer>();
    private long contigNo = 0L;
    private double median = 0.0;
    private final File basicStatsFile;
    private long total_gc_count = 0L;
    private double total_gc_percent = 0.0;
    private final File objFile;
    private File tmpObjFile;
    private ObjectOutputStream contigRecordsStream;
    private long total_n_count = 0L;
    private double nratio;

    public BasicStatsCompute(File targetFolder, boolean justModelling) {
        this.basicStatsFile = !justModelling ? new File(((AlignEvalCommand)Utilities.current_cmd).getEvalDestFolder().getAbsolutePath() + File.separator + Utilities.assemblystatsFile) : null;
        this.objFile = new File(targetFolder.getAbsolutePath() + File.separator + "contigRecords.bin");
        try {
            this.tmpObjFile = new File(Utilities.rootDir.getAbsolutePath() + File.separator + "contigRec.tmp");
            this.tmpObjFile.deleteOnExit();
            this.contigRecordsStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.tmpObjFile)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public long getNumberofContigs() {
        return this.contigNo;
    }

    public File getStatsFile() {
        return this.basicStatsFile;
    }

    public long getSum() {
        return this.sum;
    }

    public Map<Enums.NLevel, Integer> getNLevels() {
        return this.nlevels;
    }

    public long getTotalGCcount() {
        return this.total_gc_count;
    }

    public double getTotalGCpercent() {
        return this.total_gc_percent;
    }

    public double getNRatio() {
        return this.nratio;
    }

    public long getNCount() {
        return this.total_n_count;
    }

    public void addLength(ReadRecord r) {
        ++this.contigNo;
        try {
            this.contigRecordsStream.writeObject(new ContigRecord(r.getName(), r.getReadRecordLength(), r.getGCcount(), r.getNcount(), ((FastaRecord)r).getHashValue(), ((FastaRecord)r).getSeqHashValue(), ((FastaRecord)r).getnIntervalsTree()));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (r.getReadRecordLength() < this.min) {
            this.min = r.getReadRecordLength();
        }
        if (r.getReadRecordLength() > this.max) {
            this.max = r.getReadRecordLength();
        }
        this.sum += (long)r.getReadRecordLength();
        this.total_gc_count += (long)r.getGCcount();
        this.total_n_count += (long)r.getNcount();
    }

    private void setMean() {
        this.mean = (double)this.sum / (double)this.contigNo;
    }

    public double getMean() {
        return this.mean;
    }

    private void setMedian() {
        this.median = this.contigRecordsArray[this.contigRecordsArray.length / 2].getLength();
    }

    public double getMedian() {
        return this.median;
    }

    private void setMinMax() {
        this.max = this.contigRecordsArray[this.contigRecordsArray.length - 1].getLength();
        this.min = this.contigRecordsArray[0].getLength();
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    private void setGCPercent() {
        this.total_gc_percent = 100.0 * (double)this.total_gc_count / (double)this.getSum();
    }

    private void setNRatio() {
        this.nratio = (double)this.total_n_count / (double)this.getSum();
    }

    public void computeStats() {
        this.setMean();
        this.setGCPercent();
        this.setNRatio();
        try {
            this.contigRecordsStream.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.contigRecordsArray = new ContigRecord[(int)this.contigNo];
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.tmpObjFile)));
            int i = 0;
            while (true) {
                this.contigRecordsArray[i] = (ContigRecord)ois.readObject();
                ++i;
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            try {
                ois.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        catch (IOException ex) {
            try {
                if (!(ex instanceof EOFException)) {
                    ex.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    ois.close();
                }
                catch (IOException ex2) {
                    ex2.printStackTrace();
                }
            }
        }
        Arrays.sort(this.contigRecordsArray);
        this.setMedian();
        Enums.NLevel Ngoal = Enums.NLevel.N10;
        Enums.LLevel Lgoal = Enums.LLevel.L10;
        double temp = 0.0;
        int count = 0;
        for (int i = this.contigRecordsArray.length - 1; i >= 0; --i) {
            ++count;
            temp += (double)this.contigRecordsArray[i].getLength();
            if (Ngoal == null || !(Utilities.calcPercentage(temp, (double)this.sum) >= Ngoal.getThreshold())) continue;
            this.nlevels.put(Ngoal, this.contigRecordsArray[i].getLength());
            this.llevels.put(Lgoal, count);
            Ngoal = Ngoal.nextLevel();
            Lgoal = Lgoal.nextLevel();
        }
        if (Ngoal != null) {
            Enums.NLevel tmp = Ngoal.prevLevel();
            Enums.LLevel tmp2 = Lgoal.prevLevel();
            while (Ngoal != null) {
                this.nlevels.put(Ngoal, this.nlevels.get(tmp));
                this.llevels.put(Lgoal, this.llevels.get(tmp2));
                Ngoal = Ngoal.nextLevel();
                Lgoal = Lgoal.nextLevel();
            }
        }
    }

    public void write2File() {
        NumberFormat nr = Utilities.numberFormatter;
        HashMap<String, ContigRecord> contRecMap = new HashMap<String, ContigRecord>();
        for (ContigRecord r : this.contigRecordsArray) {
            contRecMap.put(r.getContigName(), r);
        }
        try (ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.objFile)));){
            out.writeObject(contRecMap);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.getStatsFile() == null) {
            return;
        }
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(this.getStatsFile()));){
            bw.append("Number of scaffolds: " + nr.format(this.contigNo) + Utilities.ls);
            bw.append("Total scaffold length: " + nr.format(this.getSum()) + Utilities.ls);
            bw.append("Max scaffold length: " + nr.format(this.getMax()) + Utilities.ls);
            bw.append("Min scaffold length: " + nr.format(this.getMin()) + Utilities.ls);
            bw.append("Mean scaffold length: " + nr.format(this.getMean()) + Utilities.ls);
            bw.append("Median scaffold length: " + nr.format(this.getMedian()) + Utilities.ls);
            bw.append("GC count: " + nr.format(this.getTotalGCcount()) + Utilities.ls);
            bw.append("GC percentage: " + nr.format(this.getTotalGCpercent()) + Utilities.ls);
            bw.append("Number of Ambigious (N) bases: " + nr.format(this.getNCount()) + Utilities.ls);
            bw.append("Ratio of Ambigious (N) bases: " + nr.format(this.getNRatio()) + Utilities.ls);
            bw.append(Utilities.ls + "N Stats" + Utilities.ls);
            for (Enums.NLevel nLevel : Enums.NLevel.values()) {
                bw.append(nLevel + "\t" + nr.format(this.nlevels.get(nLevel)) + Utilities.ls);
            }
            bw.append(Utilities.ls + "L Stats" + Utilities.ls);
            for (Enum enum_ : Enums.LLevel.values()) {
                bw.append(enum_ + "\t" + nr.format(this.llevels.get(enum_)) + Utilities.ls);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

